/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.security.ArticleIndicator;
import com.microsoft.graph.models.security.Artifact;
import com.microsoft.graph.models.security.IndicatorSource;
import com.microsoft.graph.models.security.IntelligenceProfileIndicator;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Indicator
extends Entity
implements Parsable {
    @Nonnull
    public static Indicator createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.articleIndicator": {
                    return new ArticleIndicator();
                }
                case "#microsoft.graph.security.intelligenceProfileIndicator": {
                    return new IntelligenceProfileIndicator();
                }
            }
        }
        return new Indicator();
    }

    @Nullable
    public Artifact getArtifact() {
        return (Artifact)this.backingStore.get("artifact");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("artifact", n -> this.setArtifact((Artifact)n.getObjectValue(Artifact::createFromDiscriminatorValue)));
        deserializerMap.put("source", n -> this.setSource((IndicatorSource)n.getEnumValue(IndicatorSource::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IndicatorSource getSource() {
        return (IndicatorSource)((Object)this.backingStore.get("source"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("artifact", (Parsable)this.getArtifact(), new Parsable[0]);
        writer.writeEnumValue("source", (Enum)this.getSource());
    }

    public void setArtifact(@Nullable Artifact value) {
        this.backingStore.set("artifact", (Object)value);
    }

    public void setSource(@Nullable IndicatorSource value) {
        this.backingStore.set("source", (Object)value);
    }
}

