/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.graph.models.callrecords.DeviceInfo;
import com.microsoft.graph.models.callrecords.MediaStream;
import com.microsoft.graph.models.callrecords.NetworkInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Media
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Media() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Media createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Media();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public DeviceInfo getCalleeDevice() {
        return (DeviceInfo)this.backingStore.get("calleeDevice");
    }

    @Nullable
    public NetworkInfo getCalleeNetwork() {
        return (NetworkInfo)this.backingStore.get("calleeNetwork");
    }

    @Nullable
    public DeviceInfo getCallerDevice() {
        return (DeviceInfo)this.backingStore.get("callerDevice");
    }

    @Nullable
    public NetworkInfo getCallerNetwork() {
        return (NetworkInfo)this.backingStore.get("callerNetwork");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("calleeDevice", n -> this.setCalleeDevice((DeviceInfo)n.getObjectValue(DeviceInfo::createFromDiscriminatorValue)));
        deserializerMap.put("calleeNetwork", n -> this.setCalleeNetwork((NetworkInfo)n.getObjectValue(NetworkInfo::createFromDiscriminatorValue)));
        deserializerMap.put("callerDevice", n -> this.setCallerDevice((DeviceInfo)n.getObjectValue(DeviceInfo::createFromDiscriminatorValue)));
        deserializerMap.put("callerNetwork", n -> this.setCallerNetwork((NetworkInfo)n.getObjectValue(NetworkInfo::createFromDiscriminatorValue)));
        deserializerMap.put("label", n -> this.setLabel(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("streams", n -> this.setStreams(n.getCollectionOfObjectValues(MediaStream::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getLabel() {
        return (String)this.backingStore.get("label");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<MediaStream> getStreams() {
        return (List)this.backingStore.get("streams");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("calleeDevice", (Parsable)this.getCalleeDevice(), new Parsable[0]);
        writer.writeObjectValue("calleeNetwork", (Parsable)this.getCalleeNetwork(), new Parsable[0]);
        writer.writeObjectValue("callerDevice", (Parsable)this.getCallerDevice(), new Parsable[0]);
        writer.writeObjectValue("callerNetwork", (Parsable)this.getCallerNetwork(), new Parsable[0]);
        writer.writeStringValue("label", this.getLabel());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("streams", this.getStreams());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCalleeDevice(@Nullable DeviceInfo value) {
        this.backingStore.set("calleeDevice", (Object)value);
    }

    public void setCalleeNetwork(@Nullable NetworkInfo value) {
        this.backingStore.set("calleeNetwork", (Object)value);
    }

    public void setCallerDevice(@Nullable DeviceInfo value) {
        this.backingStore.set("callerDevice", (Object)value);
    }

    public void setCallerNetwork(@Nullable NetworkInfo value) {
        this.backingStore.set("callerNetwork", (Object)value);
    }

    public void setLabel(@Nullable String value) {
        this.backingStore.set("label", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStreams(@Nullable List<MediaStream> value) {
        this.backingStore.set("streams", value);
    }
}

