/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.OsVersionCount;
import com.microsoft.graph.models.WindowsMalwareCategoryCount;
import com.microsoft.graph.models.WindowsMalwareExecutionStateCount;
import com.microsoft.graph.models.WindowsMalwareNameCount;
import com.microsoft.graph.models.WindowsMalwareSeverityCount;
import com.microsoft.graph.models.WindowsMalwareStateCount;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsMalwareOverview
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WindowsMalwareOverview() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WindowsMalwareOverview createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareOverview();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("malwareCategorySummary", n -> this.setMalwareCategorySummary(n.getCollectionOfObjectValues(WindowsMalwareCategoryCount::createFromDiscriminatorValue)));
        deserializerMap.put("malwareDetectedDeviceCount", n -> this.setMalwareDetectedDeviceCount(n.getIntegerValue()));
        deserializerMap.put("malwareExecutionStateSummary", n -> this.setMalwareExecutionStateSummary(n.getCollectionOfObjectValues(WindowsMalwareExecutionStateCount::createFromDiscriminatorValue)));
        deserializerMap.put("malwareNameSummary", n -> this.setMalwareNameSummary(n.getCollectionOfObjectValues(WindowsMalwareNameCount::createFromDiscriminatorValue)));
        deserializerMap.put("malwareSeveritySummary", n -> this.setMalwareSeveritySummary(n.getCollectionOfObjectValues(WindowsMalwareSeverityCount::createFromDiscriminatorValue)));
        deserializerMap.put("malwareStateSummary", n -> this.setMalwareStateSummary(n.getCollectionOfObjectValues(WindowsMalwareStateCount::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("osVersionsSummary", n -> this.setOsVersionsSummary(n.getCollectionOfObjectValues(OsVersionCount::createFromDiscriminatorValue)));
        deserializerMap.put("totalDistinctMalwareCount", n -> this.setTotalDistinctMalwareCount(n.getIntegerValue()));
        deserializerMap.put("totalMalwareCount", n -> this.setTotalMalwareCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public List<WindowsMalwareCategoryCount> getMalwareCategorySummary() {
        return (List)this.backingStore.get("malwareCategorySummary");
    }

    @Nullable
    public Integer getMalwareDetectedDeviceCount() {
        return (Integer)this.backingStore.get("malwareDetectedDeviceCount");
    }

    @Nullable
    public List<WindowsMalwareExecutionStateCount> getMalwareExecutionStateSummary() {
        return (List)this.backingStore.get("malwareExecutionStateSummary");
    }

    @Nullable
    public List<WindowsMalwareNameCount> getMalwareNameSummary() {
        return (List)this.backingStore.get("malwareNameSummary");
    }

    @Nullable
    public List<WindowsMalwareSeverityCount> getMalwareSeveritySummary() {
        return (List)this.backingStore.get("malwareSeveritySummary");
    }

    @Nullable
    public List<WindowsMalwareStateCount> getMalwareStateSummary() {
        return (List)this.backingStore.get("malwareStateSummary");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<OsVersionCount> getOsVersionsSummary() {
        return (List)this.backingStore.get("osVersionsSummary");
    }

    @Nullable
    public Integer getTotalDistinctMalwareCount() {
        return (Integer)this.backingStore.get("totalDistinctMalwareCount");
    }

    @Nullable
    public Integer getTotalMalwareCount() {
        return (Integer)this.backingStore.get("totalMalwareCount");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("malwareCategorySummary", this.getMalwareCategorySummary());
        writer.writeIntegerValue("malwareDetectedDeviceCount", this.getMalwareDetectedDeviceCount());
        writer.writeCollectionOfObjectValues("malwareExecutionStateSummary", this.getMalwareExecutionStateSummary());
        writer.writeCollectionOfObjectValues("malwareNameSummary", this.getMalwareNameSummary());
        writer.writeCollectionOfObjectValues("malwareSeveritySummary", this.getMalwareSeveritySummary());
        writer.writeCollectionOfObjectValues("malwareStateSummary", this.getMalwareStateSummary());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("osVersionsSummary", this.getOsVersionsSummary());
        writer.writeIntegerValue("totalDistinctMalwareCount", this.getTotalDistinctMalwareCount());
        writer.writeIntegerValue("totalMalwareCount", this.getTotalMalwareCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setMalwareCategorySummary(@Nullable List<WindowsMalwareCategoryCount> value) {
        this.backingStore.set("malwareCategorySummary", value);
    }

    public void setMalwareDetectedDeviceCount(@Nullable Integer value) {
        this.backingStore.set("malwareDetectedDeviceCount", (Object)value);
    }

    public void setMalwareExecutionStateSummary(@Nullable List<WindowsMalwareExecutionStateCount> value) {
        this.backingStore.set("malwareExecutionStateSummary", value);
    }

    public void setMalwareNameSummary(@Nullable List<WindowsMalwareNameCount> value) {
        this.backingStore.set("malwareNameSummary", value);
    }

    public void setMalwareSeveritySummary(@Nullable List<WindowsMalwareSeverityCount> value) {
        this.backingStore.set("malwareSeveritySummary", value);
    }

    public void setMalwareStateSummary(@Nullable List<WindowsMalwareStateCount> value) {
        this.backingStore.set("malwareStateSummary", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOsVersionsSummary(@Nullable List<OsVersionCount> value) {
        this.backingStore.set("osVersionsSummary", value);
    }

    public void setTotalDistinctMalwareCount(@Nullable Integer value) {
        this.backingStore.set("totalDistinctMalwareCount", (Object)value);
    }

    public void setTotalMalwareCount(@Nullable Integer value) {
        this.backingStore.set("totalMalwareCount", (Object)value);
    }
}

