/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.models.AuthenticationMethodTarget;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VoiceAuthenticationMethodConfiguration
extends AuthenticationMethodConfiguration
implements Parsable {
    public VoiceAuthenticationMethodConfiguration() {
        this.setOdataType("#microsoft.graph.voiceAuthenticationMethodConfiguration");
    }

    @Nonnull
    public static VoiceAuthenticationMethodConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new VoiceAuthenticationMethodConfiguration();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("includeTargets", n -> this.setIncludeTargets(n.getCollectionOfObjectValues(AuthenticationMethodTarget::createFromDiscriminatorValue)));
        deserializerMap.put("isOfficePhoneAllowed", n -> this.setIsOfficePhoneAllowed(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public List<AuthenticationMethodTarget> getIncludeTargets() {
        return (List)this.backingStore.get("includeTargets");
    }

    @Nullable
    public Boolean getIsOfficePhoneAllowed() {
        return (Boolean)this.backingStore.get("isOfficePhoneAllowed");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("includeTargets", this.getIncludeTargets());
        writer.writeBooleanValue("isOfficePhoneAllowed", this.getIsOfficePhoneAllowed());
    }

    public void setIncludeTargets(@Nullable List<AuthenticationMethodTarget> value) {
        this.backingStore.set("includeTargets", value);
    }

    public void setIsOfficePhoneAllowed(@Nullable Boolean value) {
        this.backingStore.set("isOfficePhoneAllowed", (Object)value);
    }
}

