/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CommunicationsIdentitySet;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.VirtualEventExternalInformation;
import com.microsoft.graph.models.VirtualEventPresenter;
import com.microsoft.graph.models.VirtualEventSession;
import com.microsoft.graph.models.VirtualEventSettings;
import com.microsoft.graph.models.VirtualEventStatus;
import com.microsoft.graph.models.VirtualEventTownhall;
import com.microsoft.graph.models.VirtualEventWebinar;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VirtualEvent
extends Entity
implements Parsable {
    @Nonnull
    public static VirtualEvent createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.virtualEventTownhall": {
                    return new VirtualEventTownhall();
                }
                case "#microsoft.graph.virtualEventWebinar": {
                    return new VirtualEventWebinar();
                }
            }
        }
        return new VirtualEvent();
    }

    @Nullable
    public CommunicationsIdentitySet getCreatedBy() {
        return (CommunicationsIdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public ItemBody getDescription() {
        return (ItemBody)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public DateTimeTimeZone getEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("endDateTime");
    }

    @Nullable
    public List<VirtualEventExternalInformation> getExternalEventInformation() {
        return (List)this.backingStore.get("externalEventInformation");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((CommunicationsIdentitySet)n.getObjectValue(CommunicationsIdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("externalEventInformation", n -> this.setExternalEventInformation(n.getCollectionOfObjectValues(VirtualEventExternalInformation::createFromDiscriminatorValue)));
        deserializerMap.put("presenters", n -> this.setPresenters(n.getCollectionOfObjectValues(VirtualEventPresenter::createFromDiscriminatorValue)));
        deserializerMap.put("sessions", n -> this.setSessions(n.getCollectionOfObjectValues(VirtualEventSession::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings((VirtualEventSettings)n.getObjectValue(VirtualEventSettings::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("status", n -> this.setStatus((VirtualEventStatus)n.getEnumValue(VirtualEventStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public List<VirtualEventPresenter> getPresenters() {
        return (List)this.backingStore.get("presenters");
    }

    @Nullable
    public List<VirtualEventSession> getSessions() {
        return (List)this.backingStore.get("sessions");
    }

    @Nullable
    public VirtualEventSettings getSettings() {
        return (VirtualEventSettings)this.backingStore.get("settings");
    }

    @Nullable
    public DateTimeTimeZone getStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("startDateTime");
    }

    @Nullable
    public VirtualEventStatus getStatus() {
        return (VirtualEventStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeObjectValue("description", (Parsable)this.getDescription(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("endDateTime", (Parsable)this.getEndDateTime(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("externalEventInformation", this.getExternalEventInformation());
        writer.writeCollectionOfObjectValues("presenters", this.getPresenters());
        writer.writeCollectionOfObjectValues("sessions", this.getSessions());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
        writer.writeObjectValue("startDateTime", (Parsable)this.getStartDateTime(), new Parsable[0]);
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedBy(@Nullable CommunicationsIdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setDescription(@Nullable ItemBody value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setExternalEventInformation(@Nullable List<VirtualEventExternalInformation> value) {
        this.backingStore.set("externalEventInformation", value);
    }

    public void setPresenters(@Nullable List<VirtualEventPresenter> value) {
        this.backingStore.set("presenters", value);
    }

    public void setSessions(@Nullable List<VirtualEventSession> value) {
        this.backingStore.set("sessions", value);
    }

    public void setSettings(@Nullable VirtualEventSettings value) {
        this.backingStore.set("settings", (Object)value);
    }

    public void setStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setStatus(@Nullable VirtualEventStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

