/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttackSimulationUser;
import com.microsoft.graph.models.UserSimulationEventInfo;
import com.microsoft.graph.models.UserTrainingEventInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserSimulationDetails
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserSimulationDetails() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserSimulationDetails createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserSimulationDetails();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Integer getAssignedTrainingsCount() {
        return (Integer)this.backingStore.get("assignedTrainingsCount");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getCompletedTrainingsCount() {
        return (Integer)this.backingStore.get("completedTrainingsCount");
    }

    @Nullable
    public OffsetDateTime getCompromisedDateTime() {
        return (OffsetDateTime)this.backingStore.get("compromisedDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("assignedTrainingsCount", n -> this.setAssignedTrainingsCount(n.getIntegerValue()));
        deserializerMap.put("completedTrainingsCount", n -> this.setCompletedTrainingsCount(n.getIntegerValue()));
        deserializerMap.put("compromisedDateTime", n -> this.setCompromisedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("inProgressTrainingsCount", n -> this.setInProgressTrainingsCount(n.getIntegerValue()));
        deserializerMap.put("isCompromised", n -> this.setIsCompromised(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("reportedPhishDateTime", n -> this.setReportedPhishDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("simulationEvents", n -> this.setSimulationEvents(n.getCollectionOfObjectValues(UserSimulationEventInfo::createFromDiscriminatorValue)));
        deserializerMap.put("simulationUser", n -> this.setSimulationUser((AttackSimulationUser)n.getObjectValue(AttackSimulationUser::createFromDiscriminatorValue)));
        deserializerMap.put("trainingEvents", n -> this.setTrainingEvents(n.getCollectionOfObjectValues(UserTrainingEventInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Integer getInProgressTrainingsCount() {
        return (Integer)this.backingStore.get("inProgressTrainingsCount");
    }

    @Nullable
    public Boolean getIsCompromised() {
        return (Boolean)this.backingStore.get("isCompromised");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getReportedPhishDateTime() {
        return (OffsetDateTime)this.backingStore.get("reportedPhishDateTime");
    }

    @Nullable
    public List<UserSimulationEventInfo> getSimulationEvents() {
        return (List)this.backingStore.get("simulationEvents");
    }

    @Nullable
    public AttackSimulationUser getSimulationUser() {
        return (AttackSimulationUser)this.backingStore.get("simulationUser");
    }

    @Nullable
    public List<UserTrainingEventInfo> getTrainingEvents() {
        return (List)this.backingStore.get("trainingEvents");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("assignedTrainingsCount", this.getAssignedTrainingsCount());
        writer.writeIntegerValue("completedTrainingsCount", this.getCompletedTrainingsCount());
        writer.writeOffsetDateTimeValue("compromisedDateTime", this.getCompromisedDateTime());
        writer.writeIntegerValue("inProgressTrainingsCount", this.getInProgressTrainingsCount());
        writer.writeBooleanValue("isCompromised", this.getIsCompromised());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("reportedPhishDateTime", this.getReportedPhishDateTime());
        writer.writeCollectionOfObjectValues("simulationEvents", this.getSimulationEvents());
        writer.writeObjectValue("simulationUser", (Parsable)this.getSimulationUser(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("trainingEvents", this.getTrainingEvents());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAssignedTrainingsCount(@Nullable Integer value) {
        this.backingStore.set("assignedTrainingsCount", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCompletedTrainingsCount(@Nullable Integer value) {
        this.backingStore.set("completedTrainingsCount", (Object)value);
    }

    public void setCompromisedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("compromisedDateTime", (Object)value);
    }

    public void setInProgressTrainingsCount(@Nullable Integer value) {
        this.backingStore.set("inProgressTrainingsCount", (Object)value);
    }

    public void setIsCompromised(@Nullable Boolean value) {
        this.backingStore.set("isCompromised", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReportedPhishDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("reportedPhishDateTime", (Object)value);
    }

    public void setSimulationEvents(@Nullable List<UserSimulationEventInfo> value) {
        this.backingStore.set("simulationEvents", value);
    }

    public void setSimulationUser(@Nullable AttackSimulationUser value) {
        this.backingStore.set("simulationUser", (Object)value);
    }

    public void setTrainingEvents(@Nullable List<UserTrainingEventInfo> value) {
        this.backingStore.set("trainingEvents", value);
    }
}

