/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EmailRole;
import com.microsoft.graph.models.LogonType;
import com.microsoft.graph.models.UserAccountSecurityType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserSecurityState
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserSecurityState() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserSecurityState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserSecurityState();
    }

    @Nullable
    public String getAadUserId() {
        return (String)this.backingStore.get("aadUserId");
    }

    @Nullable
    public String getAccountName() {
        return (String)this.backingStore.get("accountName");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDomainName() {
        return (String)this.backingStore.get("domainName");
    }

    @Nullable
    public EmailRole getEmailRole() {
        return (EmailRole)((Object)this.backingStore.get("emailRole"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(15);
        deserializerMap.put("aadUserId", n -> this.setAadUserId(n.getStringValue()));
        deserializerMap.put("accountName", n -> this.setAccountName(n.getStringValue()));
        deserializerMap.put("domainName", n -> this.setDomainName(n.getStringValue()));
        deserializerMap.put("emailRole", n -> this.setEmailRole((EmailRole)n.getEnumValue(EmailRole::forValue)));
        deserializerMap.put("isVpn", n -> this.setIsVpn(n.getBooleanValue()));
        deserializerMap.put("logonDateTime", n -> this.setLogonDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("logonId", n -> this.setLogonId(n.getStringValue()));
        deserializerMap.put("logonIp", n -> this.setLogonIp(n.getStringValue()));
        deserializerMap.put("logonLocation", n -> this.setLogonLocation(n.getStringValue()));
        deserializerMap.put("logonType", n -> this.setLogonType((LogonType)n.getEnumValue(LogonType::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("onPremisesSecurityIdentifier", n -> this.setOnPremisesSecurityIdentifier(n.getStringValue()));
        deserializerMap.put("riskScore", n -> this.setRiskScore(n.getStringValue()));
        deserializerMap.put("userAccountType", n -> this.setUserAccountType((UserAccountSecurityType)n.getEnumValue(UserAccountSecurityType::forValue)));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsVpn() {
        return (Boolean)this.backingStore.get("isVpn");
    }

    @Nullable
    public OffsetDateTime getLogonDateTime() {
        return (OffsetDateTime)this.backingStore.get("logonDateTime");
    }

    @Nullable
    public String getLogonId() {
        return (String)this.backingStore.get("logonId");
    }

    @Nullable
    public String getLogonIp() {
        return (String)this.backingStore.get("logonIp");
    }

    @Nullable
    public String getLogonLocation() {
        return (String)this.backingStore.get("logonLocation");
    }

    @Nullable
    public LogonType getLogonType() {
        return (LogonType)((Object)this.backingStore.get("logonType"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOnPremisesSecurityIdentifier() {
        return (String)this.backingStore.get("onPremisesSecurityIdentifier");
    }

    @Nullable
    public String getRiskScore() {
        return (String)this.backingStore.get("riskScore");
    }

    @Nullable
    public UserAccountSecurityType getUserAccountType() {
        return (UserAccountSecurityType)((Object)this.backingStore.get("userAccountType"));
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("aadUserId", this.getAadUserId());
        writer.writeStringValue("accountName", this.getAccountName());
        writer.writeStringValue("domainName", this.getDomainName());
        writer.writeEnumValue("emailRole", (Enum)this.getEmailRole());
        writer.writeBooleanValue("isVpn", this.getIsVpn());
        writer.writeOffsetDateTimeValue("logonDateTime", this.getLogonDateTime());
        writer.writeStringValue("logonId", this.getLogonId());
        writer.writeStringValue("logonIp", this.getLogonIp());
        writer.writeStringValue("logonLocation", this.getLogonLocation());
        writer.writeEnumValue("logonType", (Enum)this.getLogonType());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("onPremisesSecurityIdentifier", this.getOnPremisesSecurityIdentifier());
        writer.writeStringValue("riskScore", this.getRiskScore());
        writer.writeEnumValue("userAccountType", (Enum)this.getUserAccountType());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAadUserId(@Nullable String value) {
        this.backingStore.set("aadUserId", (Object)value);
    }

    public void setAccountName(@Nullable String value) {
        this.backingStore.set("accountName", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDomainName(@Nullable String value) {
        this.backingStore.set("domainName", (Object)value);
    }

    public void setEmailRole(@Nullable EmailRole value) {
        this.backingStore.set("emailRole", (Object)value);
    }

    public void setIsVpn(@Nullable Boolean value) {
        this.backingStore.set("isVpn", (Object)value);
    }

    public void setLogonDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("logonDateTime", (Object)value);
    }

    public void setLogonId(@Nullable String value) {
        this.backingStore.set("logonId", (Object)value);
    }

    public void setLogonIp(@Nullable String value) {
        this.backingStore.set("logonIp", (Object)value);
    }

    public void setLogonLocation(@Nullable String value) {
        this.backingStore.set("logonLocation", (Object)value);
    }

    public void setLogonType(@Nullable LogonType value) {
        this.backingStore.set("logonType", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOnPremisesSecurityIdentifier(@Nullable String value) {
        this.backingStore.set("onPremisesSecurityIdentifier", (Object)value);
    }

    public void setRiskScore(@Nullable String value) {
        this.backingStore.set("riskScore", (Object)value);
    }

    public void setUserAccountType(@Nullable UserAccountSecurityType value) {
        this.backingStore.set("userAccountType", (Object)value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }
}

