/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SynchronizationScheduleState;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SynchronizationSchedule
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SynchronizationSchedule() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SynchronizationSchedule createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SynchronizationSchedule();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getExpiration() {
        return (OffsetDateTime)this.backingStore.get("expiration");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("expiration", n -> this.setExpiration(n.getOffsetDateTimeValue()));
        deserializerMap.put("interval", n -> this.setInterval(n.getPeriodAndDurationValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("state", n -> this.setState((SynchronizationScheduleState)n.getEnumValue(SynchronizationScheduleState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public PeriodAndDuration getInterval() {
        return (PeriodAndDuration)this.backingStore.get("interval");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public SynchronizationScheduleState getState() {
        return (SynchronizationScheduleState)((Object)this.backingStore.get("state"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("expiration", this.getExpiration());
        writer.writePeriodAndDurationValue("interval", this.getInterval());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExpiration(@Nullable OffsetDateTime value) {
        this.backingStore.set("expiration", (Object)value);
    }

    public void setInterval(@Nullable PeriodAndDuration value) {
        this.backingStore.set("interval", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setState(@Nullable SynchronizationScheduleState value) {
        this.backingStore.set("state", (Object)value);
    }
}

