/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttackSimulationRoot;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.SecureScore;
import com.microsoft.graph.models.SecureScoreControlProfile;
import com.microsoft.graph.models.SubjectRightsRequest;
import com.microsoft.graph.models.security.Alert;
import com.microsoft.graph.models.security.CasesRoot;
import com.microsoft.graph.models.security.IdentityContainer;
import com.microsoft.graph.models.security.Incident;
import com.microsoft.graph.models.security.LabelsRoot;
import com.microsoft.graph.models.security.ThreatIntelligence;
import com.microsoft.graph.models.security.TriggerTypesRoot;
import com.microsoft.graph.models.security.TriggersRoot;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Security
extends Entity
implements Parsable {
    @Nonnull
    public static Security createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Security();
    }

    @Nullable
    public List<Alert> getAlerts() {
        return (List)this.backingStore.get("alerts");
    }

    @Nullable
    public List<Alert> getAlertsV2() {
        return (List)this.backingStore.get("alertsV2");
    }

    @Nullable
    public AttackSimulationRoot getAttackSimulation() {
        return (AttackSimulationRoot)this.backingStore.get("attackSimulation");
    }

    @Nullable
    public CasesRoot getCases() {
        return (CasesRoot)this.backingStore.get("cases");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("alerts", n -> this.setAlerts(n.getCollectionOfObjectValues(Alert::createFromDiscriminatorValue)));
        deserializerMap.put("alerts_v2", n -> this.setAlertsV2(n.getCollectionOfObjectValues(Alert::createFromDiscriminatorValue)));
        deserializerMap.put("attackSimulation", n -> this.setAttackSimulation((AttackSimulationRoot)n.getObjectValue(AttackSimulationRoot::createFromDiscriminatorValue)));
        deserializerMap.put("cases", n -> this.setCases((CasesRoot)n.getObjectValue(CasesRoot::createFromDiscriminatorValue)));
        deserializerMap.put("identities", n -> this.setIdentities((IdentityContainer)n.getObjectValue(IdentityContainer::createFromDiscriminatorValue)));
        deserializerMap.put("incidents", n -> this.setIncidents(n.getCollectionOfObjectValues(Incident::createFromDiscriminatorValue)));
        deserializerMap.put("labels", n -> this.setLabels((LabelsRoot)n.getObjectValue(LabelsRoot::createFromDiscriminatorValue)));
        deserializerMap.put("secureScoreControlProfiles", n -> this.setSecureScoreControlProfiles(n.getCollectionOfObjectValues(SecureScoreControlProfile::createFromDiscriminatorValue)));
        deserializerMap.put("secureScores", n -> this.setSecureScores(n.getCollectionOfObjectValues(SecureScore::createFromDiscriminatorValue)));
        deserializerMap.put("subjectRightsRequests", n -> this.setSubjectRightsRequests(n.getCollectionOfObjectValues(SubjectRightsRequest::createFromDiscriminatorValue)));
        deserializerMap.put("threatIntelligence", n -> this.setThreatIntelligence((ThreatIntelligence)n.getObjectValue(ThreatIntelligence::createFromDiscriminatorValue)));
        deserializerMap.put("triggers", n -> this.setTriggers((TriggersRoot)n.getObjectValue(TriggersRoot::createFromDiscriminatorValue)));
        deserializerMap.put("triggerTypes", n -> this.setTriggerTypes((TriggerTypesRoot)n.getObjectValue(TriggerTypesRoot::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentityContainer getIdentities() {
        return (IdentityContainer)this.backingStore.get("identities");
    }

    @Nullable
    public List<Incident> getIncidents() {
        return (List)this.backingStore.get("incidents");
    }

    @Nullable
    public LabelsRoot getLabels() {
        return (LabelsRoot)this.backingStore.get("labels");
    }

    @Nullable
    public List<SecureScoreControlProfile> getSecureScoreControlProfiles() {
        return (List)this.backingStore.get("secureScoreControlProfiles");
    }

    @Nullable
    public List<SecureScore> getSecureScores() {
        return (List)this.backingStore.get("secureScores");
    }

    @Nullable
    public List<SubjectRightsRequest> getSubjectRightsRequests() {
        return (List)this.backingStore.get("subjectRightsRequests");
    }

    @Nullable
    public ThreatIntelligence getThreatIntelligence() {
        return (ThreatIntelligence)this.backingStore.get("threatIntelligence");
    }

    @Nullable
    public TriggersRoot getTriggers() {
        return (TriggersRoot)this.backingStore.get("triggers");
    }

    @Nullable
    public TriggerTypesRoot getTriggerTypes() {
        return (TriggerTypesRoot)this.backingStore.get("triggerTypes");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("alerts", this.getAlerts());
        writer.writeCollectionOfObjectValues("alerts_v2", this.getAlertsV2());
        writer.writeObjectValue("attackSimulation", (Parsable)this.getAttackSimulation(), new Parsable[0]);
        writer.writeObjectValue("cases", (Parsable)this.getCases(), new Parsable[0]);
        writer.writeObjectValue("identities", (Parsable)this.getIdentities(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("incidents", this.getIncidents());
        writer.writeObjectValue("labels", (Parsable)this.getLabels(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("secureScoreControlProfiles", this.getSecureScoreControlProfiles());
        writer.writeCollectionOfObjectValues("secureScores", this.getSecureScores());
        writer.writeCollectionOfObjectValues("subjectRightsRequests", this.getSubjectRightsRequests());
        writer.writeObjectValue("threatIntelligence", (Parsable)this.getThreatIntelligence(), new Parsable[0]);
        writer.writeObjectValue("triggers", (Parsable)this.getTriggers(), new Parsable[0]);
        writer.writeObjectValue("triggerTypes", (Parsable)this.getTriggerTypes(), new Parsable[0]);
    }

    public void setAlerts(@Nullable List<Alert> value) {
        this.backingStore.set("alerts", value);
    }

    public void setAlertsV2(@Nullable List<Alert> value) {
        this.backingStore.set("alertsV2", value);
    }

    public void setAttackSimulation(@Nullable AttackSimulationRoot value) {
        this.backingStore.set("attackSimulation", (Object)value);
    }

    public void setCases(@Nullable CasesRoot value) {
        this.backingStore.set("cases", (Object)value);
    }

    public void setIdentities(@Nullable IdentityContainer value) {
        this.backingStore.set("identities", (Object)value);
    }

    public void setIncidents(@Nullable List<Incident> value) {
        this.backingStore.set("incidents", value);
    }

    public void setLabels(@Nullable LabelsRoot value) {
        this.backingStore.set("labels", (Object)value);
    }

    public void setSecureScoreControlProfiles(@Nullable List<SecureScoreControlProfile> value) {
        this.backingStore.set("secureScoreControlProfiles", value);
    }

    public void setSecureScores(@Nullable List<SecureScore> value) {
        this.backingStore.set("secureScores", value);
    }

    public void setSubjectRightsRequests(@Nullable List<SubjectRightsRequest> value) {
        this.backingStore.set("subjectRightsRequests", value);
    }

    public void setThreatIntelligence(@Nullable ThreatIntelligence value) {
        this.backingStore.set("threatIntelligence", (Object)value);
    }

    public void setTriggers(@Nullable TriggersRoot value) {
        this.backingStore.set("triggers", (Object)value);
    }

    public void setTriggerTypes(@Nullable TriggerTypesRoot value) {
        this.backingStore.set("triggerTypes", (Object)value);
    }
}

