/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceAndAppManagementRoleAssignment;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.RoleDefinition;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RoleAssignment
extends Entity
implements Parsable {
    @Nonnull
    public static RoleAssignment createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.deviceAndAppManagementRoleAssignment": {
                    return new DeviceAndAppManagementRoleAssignment();
                }
            }
        }
        return new RoleAssignment();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("resourceScopes", n -> this.setResourceScopes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("roleDefinition", n -> this.setRoleDefinition((RoleDefinition)n.getObjectValue(RoleDefinition::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<String> getResourceScopes() {
        return (List)this.backingStore.get("resourceScopes");
    }

    @Nullable
    public RoleDefinition getRoleDefinition() {
        return (RoleDefinition)this.backingStore.get("roleDefinition");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfPrimitiveValues("resourceScopes", this.getResourceScopes());
        writer.writeObjectValue("roleDefinition", (Parsable)this.getRoleDefinition(), new Parsable[0]);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setResourceScopes(@Nullable List<String> value) {
        this.backingStore.set("resourceScopes", value);
    }

    public void setRoleDefinition(@Nullable RoleDefinition value) {
        this.backingStore.set("roleDefinition", (Object)value);
    }
}

