/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.OutlookGeoCoordinates;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.graph.models.Room;
import com.microsoft.graph.models.RoomList;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Place
extends Entity
implements Parsable {
    @Nonnull
    public static Place createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.room": {
                    return new Room();
                }
                case "#microsoft.graph.roomList": {
                    return new RoomList();
                }
            }
        }
        return new Place();
    }

    @Nullable
    public PhysicalAddress getAddress() {
        return (PhysicalAddress)this.backingStore.get("address");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("address", n -> this.setAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("geoCoordinates", n -> this.setGeoCoordinates((OutlookGeoCoordinates)n.getObjectValue(OutlookGeoCoordinates::createFromDiscriminatorValue)));
        deserializerMap.put("phone", n -> this.setPhone(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public OutlookGeoCoordinates getGeoCoordinates() {
        return (OutlookGeoCoordinates)this.backingStore.get("geoCoordinates");
    }

    @Nullable
    public String getPhone() {
        return (String)this.backingStore.get("phone");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("address", (Parsable)this.getAddress(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("geoCoordinates", (Parsable)this.getGeoCoordinates(), new Parsable[0]);
        writer.writeStringValue("phone", this.getPhone());
    }

    public void setAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setGeoCoordinates(@Nullable OutlookGeoCoordinates value) {
        this.backingStore.set("geoCoordinates", (Object)value);
    }

    public void setPhone(@Nullable String value) {
        this.backingStore.set("phone", (Object)value);
    }
}

