/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EndpointType;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ParticipantInfo
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ParticipantInfo() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ParticipantInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ParticipantInfo();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCountryCode() {
        return (String)this.backingStore.get("countryCode");
    }

    @Nullable
    public EndpointType getEndpointType() {
        return (EndpointType)((Object)this.backingStore.get("endpointType"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(7);
        deserializerMap.put("countryCode", n -> this.setCountryCode(n.getStringValue()));
        deserializerMap.put("endpointType", n -> this.setEndpointType((EndpointType)n.getEnumValue(EndpointType::forValue)));
        deserializerMap.put("identity", n -> this.setIdentity((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("languageId", n -> this.setLanguageId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("participantId", n -> this.setParticipantId(n.getStringValue()));
        deserializerMap.put("region", n -> this.setRegion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getIdentity() {
        return (IdentitySet)this.backingStore.get("identity");
    }

    @Nullable
    public String getLanguageId() {
        return (String)this.backingStore.get("languageId");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getParticipantId() {
        return (String)this.backingStore.get("participantId");
    }

    @Nullable
    public String getRegion() {
        return (String)this.backingStore.get("region");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("countryCode", this.getCountryCode());
        writer.writeEnumValue("endpointType", (Enum)this.getEndpointType());
        writer.writeObjectValue("identity", (Parsable)this.getIdentity(), new Parsable[0]);
        writer.writeStringValue("languageId", this.getLanguageId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("participantId", this.getParticipantId());
        writer.writeStringValue("region", this.getRegion());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCountryCode(@Nullable String value) {
        this.backingStore.set("countryCode", (Object)value);
    }

    public void setEndpointType(@Nullable EndpointType value) {
        this.backingStore.set("endpointType", (Object)value);
    }

    public void setIdentity(@Nullable IdentitySet value) {
        this.backingStore.set("identity", (Object)value);
    }

    public void setLanguageId(@Nullable String value) {
        this.backingStore.set("languageId", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setParticipantId(@Nullable String value) {
        this.backingStore.set("participantId", (Object)value);
    }

    public void setRegion(@Nullable String value) {
        this.backingStore.set("region", (Object)value);
    }
}

