/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CalendarSharingMessage;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventMessage;
import com.microsoft.graph.models.EventMessageRequest;
import com.microsoft.graph.models.EventMessageResponse;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.Post;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OutlookItem
extends Entity
implements Parsable {
    @Nonnull
    public static OutlookItem createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.calendarSharingMessage": {
                    return new CalendarSharingMessage();
                }
                case "#microsoft.graph.contact": {
                    return new Contact();
                }
                case "#microsoft.graph.event": {
                    return new Event();
                }
                case "#microsoft.graph.eventMessage": {
                    return new EventMessage();
                }
                case "#microsoft.graph.eventMessageRequest": {
                    return new EventMessageRequest();
                }
                case "#microsoft.graph.eventMessageResponse": {
                    return new EventMessageResponse();
                }
                case "#microsoft.graph.message": {
                    return new Message();
                }
                case "#microsoft.graph.post": {
                    return new Post();
                }
            }
        }
        return new OutlookItem();
    }

    @Nullable
    public List<String> getCategories() {
        return (List)this.backingStore.get("categories");
    }

    @Nullable
    public String getChangeKey() {
        return (String)this.backingStore.get("changeKey");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("categories", n -> this.setCategories(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("changeKey", n -> this.setChangeKey(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfPrimitiveValues("categories", this.getCategories());
        writer.writeStringValue("changeKey", this.getChangeKey());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
    }

    public void setCategories(@Nullable List<String> value) {
        this.backingStore.set("categories", value);
    }

    public void setChangeKey(@Nullable String value) {
        this.backingStore.set("changeKey", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }
}

