/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttributeMapping;
import com.microsoft.graph.models.Filter;
import com.microsoft.graph.models.ObjectFlowTypes;
import com.microsoft.graph.models.ObjectMappingMetadataEntry;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ObjectMapping
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ObjectMapping() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ObjectMapping createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ObjectMapping();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<AttributeMapping> getAttributeMappings() {
        return (List)this.backingStore.get("attributeMappings");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getEnabled() {
        return (Boolean)this.backingStore.get("enabled");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("attributeMappings", n -> this.setAttributeMappings(n.getCollectionOfObjectValues(AttributeMapping::createFromDiscriminatorValue)));
        deserializerMap.put("enabled", n -> this.setEnabled(n.getBooleanValue()));
        deserializerMap.put("flowTypes", n -> this.setFlowTypes(n.getEnumSetValue(ObjectFlowTypes::forValue)));
        deserializerMap.put("metadata", n -> this.setMetadata(n.getCollectionOfObjectValues(ObjectMappingMetadataEntry::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("scope", n -> this.setScope((Filter)n.getObjectValue(Filter::createFromDiscriminatorValue)));
        deserializerMap.put("sourceObjectName", n -> this.setSourceObjectName(n.getStringValue()));
        deserializerMap.put("targetObjectName", n -> this.setTargetObjectName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public EnumSet<ObjectFlowTypes> getFlowTypes() {
        return (EnumSet)this.backingStore.get("flowTypes");
    }

    @Nullable
    public List<ObjectMappingMetadataEntry> getMetadata() {
        return (List)this.backingStore.get("metadata");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Filter getScope() {
        return (Filter)this.backingStore.get("scope");
    }

    @Nullable
    public String getSourceObjectName() {
        return (String)this.backingStore.get("sourceObjectName");
    }

    @Nullable
    public String getTargetObjectName() {
        return (String)this.backingStore.get("targetObjectName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("attributeMappings", this.getAttributeMappings());
        writer.writeBooleanValue("enabled", this.getEnabled());
        writer.writeEnumSetValue("flowTypes", this.getFlowTypes());
        writer.writeCollectionOfObjectValues("metadata", this.getMetadata());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("scope", (Parsable)this.getScope(), new Parsable[0]);
        writer.writeStringValue("sourceObjectName", this.getSourceObjectName());
        writer.writeStringValue("targetObjectName", this.getTargetObjectName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAttributeMappings(@Nullable List<AttributeMapping> value) {
        this.backingStore.set("attributeMappings", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEnabled(@Nullable Boolean value) {
        this.backingStore.set("enabled", (Object)value);
    }

    public void setFlowTypes(@Nullable EnumSet<ObjectFlowTypes> value) {
        this.backingStore.set("flowTypes", value);
    }

    public void setMetadata(@Nullable List<ObjectMappingMetadataEntry> value) {
        this.backingStore.set("metadata", value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setScope(@Nullable Filter value) {
        this.backingStore.set("scope", (Object)value);
    }

    public void setSourceObjectName(@Nullable String value) {
        this.backingStore.set("sourceObjectName", (Object)value);
    }

    public void setTargetObjectName(@Nullable String value) {
        this.backingStore.set("targetObjectName", (Object)value);
    }
}

