/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ObjectIdentity
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ObjectIdentity() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ObjectIdentity createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ObjectIdentity();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("issuer", n -> this.setIssuer(n.getStringValue()));
        deserializerMap.put("issuerAssignedId", n -> this.setIssuerAssignedId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("signInType", n -> this.setSignInType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIssuer() {
        return (String)this.backingStore.get("issuer");
    }

    @Nullable
    public String getIssuerAssignedId() {
        return (String)this.backingStore.get("issuerAssignedId");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getSignInType() {
        return (String)this.backingStore.get("signInType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("issuer", this.getIssuer());
        writer.writeStringValue("issuerAssignedId", this.getIssuerAssignedId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("signInType", this.getSignInType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIssuer(@Nullable String value) {
        this.backingStore.set("issuer", (Object)value);
    }

    public void setIssuerAssignedId(@Nullable String value) {
        this.backingStore.set("issuerAssignedId", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSignInType(@Nullable String value) {
        this.backingStore.set("signInType", (Object)value);
    }
}

