/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidManagedAppRegistration;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IosManagedAppRegistration;
import com.microsoft.graph.models.ManagedAppFlaggedReason;
import com.microsoft.graph.models.ManagedAppOperation;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.MobileAppIdentifier;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedAppRegistration
extends Entity
implements Parsable {
    @Nonnull
    public static ManagedAppRegistration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidManagedAppRegistration": {
                    return new AndroidManagedAppRegistration();
                }
                case "#microsoft.graph.iosManagedAppRegistration": {
                    return new IosManagedAppRegistration();
                }
            }
        }
        return new ManagedAppRegistration();
    }

    @Nullable
    public MobileAppIdentifier getAppIdentifier() {
        return (MobileAppIdentifier)this.backingStore.get("appIdentifier");
    }

    @Nullable
    public String getApplicationVersion() {
        return (String)this.backingStore.get("applicationVersion");
    }

    @Nullable
    public List<ManagedAppPolicy> getAppliedPolicies() {
        return (List)this.backingStore.get("appliedPolicies");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDeviceName() {
        return (String)this.backingStore.get("deviceName");
    }

    @Nullable
    public String getDeviceTag() {
        return (String)this.backingStore.get("deviceTag");
    }

    @Nullable
    public String getDeviceType() {
        return (String)this.backingStore.get("deviceType");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appIdentifier", n -> this.setAppIdentifier((MobileAppIdentifier)n.getObjectValue(MobileAppIdentifier::createFromDiscriminatorValue)));
        deserializerMap.put("applicationVersion", n -> this.setApplicationVersion(n.getStringValue()));
        deserializerMap.put("appliedPolicies", n -> this.setAppliedPolicies(n.getCollectionOfObjectValues(ManagedAppPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("deviceName", n -> this.setDeviceName(n.getStringValue()));
        deserializerMap.put("deviceTag", n -> this.setDeviceTag(n.getStringValue()));
        deserializerMap.put("deviceType", n -> this.setDeviceType(n.getStringValue()));
        deserializerMap.put("flaggedReasons", n -> this.setFlaggedReasons(n.getCollectionOfEnumValues(ManagedAppFlaggedReason::forValue)));
        deserializerMap.put("intendedPolicies", n -> this.setIntendedPolicies(n.getCollectionOfObjectValues(ManagedAppPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("lastSyncDateTime", n -> this.setLastSyncDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("managementSdkVersion", n -> this.setManagementSdkVersion(n.getStringValue()));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(ManagedAppOperation::createFromDiscriminatorValue)));
        deserializerMap.put("platformVersion", n -> this.setPlatformVersion(n.getStringValue()));
        deserializerMap.put("userId", n -> this.setUserId(n.getStringValue()));
        deserializerMap.put("version", n -> this.setVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<ManagedAppFlaggedReason> getFlaggedReasons() {
        return (List)this.backingStore.get("flaggedReasons");
    }

    @Nullable
    public List<ManagedAppPolicy> getIntendedPolicies() {
        return (List)this.backingStore.get("intendedPolicies");
    }

    @Nullable
    public OffsetDateTime getLastSyncDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSyncDateTime");
    }

    @Nullable
    public String getManagementSdkVersion() {
        return (String)this.backingStore.get("managementSdkVersion");
    }

    @Nullable
    public List<ManagedAppOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public String getPlatformVersion() {
        return (String)this.backingStore.get("platformVersion");
    }

    @Nullable
    public String getUserId() {
        return (String)this.backingStore.get("userId");
    }

    @Nullable
    public String getVersion() {
        return (String)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("appIdentifier", (Parsable)this.getAppIdentifier(), new Parsable[0]);
        writer.writeStringValue("applicationVersion", this.getApplicationVersion());
        writer.writeCollectionOfObjectValues("appliedPolicies", this.getAppliedPolicies());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("deviceName", this.getDeviceName());
        writer.writeStringValue("deviceTag", this.getDeviceTag());
        writer.writeStringValue("deviceType", this.getDeviceType());
        writer.writeCollectionOfEnumValues("flaggedReasons", this.getFlaggedReasons());
        writer.writeCollectionOfObjectValues("intendedPolicies", this.getIntendedPolicies());
        writer.writeOffsetDateTimeValue("lastSyncDateTime", this.getLastSyncDateTime());
        writer.writeStringValue("managementSdkVersion", this.getManagementSdkVersion());
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeStringValue("platformVersion", this.getPlatformVersion());
        writer.writeStringValue("userId", this.getUserId());
        writer.writeStringValue("version", this.getVersion());
    }

    public void setAppIdentifier(@Nullable MobileAppIdentifier value) {
        this.backingStore.set("appIdentifier", (Object)value);
    }

    public void setApplicationVersion(@Nullable String value) {
        this.backingStore.set("applicationVersion", (Object)value);
    }

    public void setAppliedPolicies(@Nullable List<ManagedAppPolicy> value) {
        this.backingStore.set("appliedPolicies", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDeviceName(@Nullable String value) {
        this.backingStore.set("deviceName", (Object)value);
    }

    public void setDeviceTag(@Nullable String value) {
        this.backingStore.set("deviceTag", (Object)value);
    }

    public void setDeviceType(@Nullable String value) {
        this.backingStore.set("deviceType", (Object)value);
    }

    public void setFlaggedReasons(@Nullable List<ManagedAppFlaggedReason> value) {
        this.backingStore.set("flaggedReasons", value);
    }

    public void setIntendedPolicies(@Nullable List<ManagedAppPolicy> value) {
        this.backingStore.set("intendedPolicies", value);
    }

    public void setLastSyncDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSyncDateTime", (Object)value);
    }

    public void setManagementSdkVersion(@Nullable String value) {
        this.backingStore.set("managementSdkVersion", (Object)value);
    }

    public void setOperations(@Nullable List<ManagedAppOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setPlatformVersion(@Nullable String value) {
        this.backingStore.set("platformVersion", (Object)value);
    }

    public void setUserId(@Nullable String value) {
        this.backingStore.set("userId", (Object)value);
    }

    public void setVersion(@Nullable String value) {
        this.backingStore.set("version", (Object)value);
    }
}

