/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IosDeviceType;
import com.microsoft.graph.models.MobileApp;
import com.microsoft.graph.models.VppLicensingType;
import com.microsoft.graph.models.VppTokenAccountType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IosVppApp
extends MobileApp
implements Parsable {
    public IosVppApp() {
        this.setOdataType("#microsoft.graph.iosVppApp");
    }

    @Nonnull
    public static IosVppApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IosVppApp();
    }

    @Nullable
    public IosDeviceType getApplicableDeviceType() {
        return (IosDeviceType)this.backingStore.get("applicableDeviceType");
    }

    @Nullable
    public String getAppStoreUrl() {
        return (String)this.backingStore.get("appStoreUrl");
    }

    @Nullable
    public String getBundleId() {
        return (String)this.backingStore.get("bundleId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("applicableDeviceType", n -> this.setApplicableDeviceType((IosDeviceType)n.getObjectValue(IosDeviceType::createFromDiscriminatorValue)));
        deserializerMap.put("appStoreUrl", n -> this.setAppStoreUrl(n.getStringValue()));
        deserializerMap.put("bundleId", n -> this.setBundleId(n.getStringValue()));
        deserializerMap.put("licensingType", n -> this.setLicensingType((VppLicensingType)n.getObjectValue(VppLicensingType::createFromDiscriminatorValue)));
        deserializerMap.put("releaseDateTime", n -> this.setReleaseDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("totalLicenseCount", n -> this.setTotalLicenseCount(n.getIntegerValue()));
        deserializerMap.put("usedLicenseCount", n -> this.setUsedLicenseCount(n.getIntegerValue()));
        deserializerMap.put("vppTokenAccountType", n -> this.setVppTokenAccountType((VppTokenAccountType)n.getEnumValue(VppTokenAccountType::forValue)));
        deserializerMap.put("vppTokenAppleId", n -> this.setVppTokenAppleId(n.getStringValue()));
        deserializerMap.put("vppTokenOrganizationName", n -> this.setVppTokenOrganizationName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public VppLicensingType getLicensingType() {
        return (VppLicensingType)this.backingStore.get("licensingType");
    }

    @Nullable
    public OffsetDateTime getReleaseDateTime() {
        return (OffsetDateTime)this.backingStore.get("releaseDateTime");
    }

    @Nullable
    public Integer getTotalLicenseCount() {
        return (Integer)this.backingStore.get("totalLicenseCount");
    }

    @Nullable
    public Integer getUsedLicenseCount() {
        return (Integer)this.backingStore.get("usedLicenseCount");
    }

    @Nullable
    public VppTokenAccountType getVppTokenAccountType() {
        return (VppTokenAccountType)((Object)this.backingStore.get("vppTokenAccountType"));
    }

    @Nullable
    public String getVppTokenAppleId() {
        return (String)this.backingStore.get("vppTokenAppleId");
    }

    @Nullable
    public String getVppTokenOrganizationName() {
        return (String)this.backingStore.get("vppTokenOrganizationName");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("applicableDeviceType", (Parsable)this.getApplicableDeviceType(), new Parsable[0]);
        writer.writeStringValue("appStoreUrl", this.getAppStoreUrl());
        writer.writeStringValue("bundleId", this.getBundleId());
        writer.writeObjectValue("licensingType", (Parsable)this.getLicensingType(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("releaseDateTime", this.getReleaseDateTime());
        writer.writeIntegerValue("totalLicenseCount", this.getTotalLicenseCount());
        writer.writeIntegerValue("usedLicenseCount", this.getUsedLicenseCount());
        writer.writeEnumValue("vppTokenAccountType", (Enum)this.getVppTokenAccountType());
        writer.writeStringValue("vppTokenAppleId", this.getVppTokenAppleId());
        writer.writeStringValue("vppTokenOrganizationName", this.getVppTokenOrganizationName());
    }

    public void setApplicableDeviceType(@Nullable IosDeviceType value) {
        this.backingStore.set("applicableDeviceType", (Object)value);
    }

    public void setAppStoreUrl(@Nullable String value) {
        this.backingStore.set("appStoreUrl", (Object)value);
    }

    public void setBundleId(@Nullable String value) {
        this.backingStore.set("bundleId", (Object)value);
    }

    public void setLicensingType(@Nullable VppLicensingType value) {
        this.backingStore.set("licensingType", (Object)value);
    }

    public void setReleaseDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("releaseDateTime", (Object)value);
    }

    public void setTotalLicenseCount(@Nullable Integer value) {
        this.backingStore.set("totalLicenseCount", (Object)value);
    }

    public void setUsedLicenseCount(@Nullable Integer value) {
        this.backingStore.set("usedLicenseCount", (Object)value);
    }

    public void setVppTokenAccountType(@Nullable VppTokenAccountType value) {
        this.backingStore.set("vppTokenAccountType", (Object)value);
    }

    public void setVppTokenAppleId(@Nullable String value) {
        this.backingStore.set("vppTokenAppleId", (Object)value);
    }

    public void setVppTokenOrganizationName(@Nullable String value) {
        this.backingStore.set("vppTokenOrganizationName", (Object)value);
    }
}

