/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FileStorageContainerSettings
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public FileStorageContainerSettings() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static FileStorageContainerSettings createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new FileStorageContainerSettings();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("isItemVersioningEnabled", n -> this.setIsItemVersioningEnabled(n.getBooleanValue()));
        deserializerMap.put("isOcrEnabled", n -> this.setIsOcrEnabled(n.getBooleanValue()));
        deserializerMap.put("itemMajorVersionLimit", n -> this.setItemMajorVersionLimit(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsItemVersioningEnabled() {
        return (Boolean)this.backingStore.get("isItemVersioningEnabled");
    }

    @Nullable
    public Boolean getIsOcrEnabled() {
        return (Boolean)this.backingStore.get("isOcrEnabled");
    }

    @Nullable
    public Integer getItemMajorVersionLimit() {
        return (Integer)this.backingStore.get("itemMajorVersionLimit");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("isItemVersioningEnabled", this.getIsItemVersioningEnabled());
        writer.writeBooleanValue("isOcrEnabled", this.getIsOcrEnabled());
        writer.writeIntegerValue("itemMajorVersionLimit", this.getItemMajorVersionLimit());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsItemVersioningEnabled(@Nullable Boolean value) {
        this.backingStore.set("isItemVersioningEnabled", (Object)value);
    }

    public void setIsOcrEnabled(@Nullable Boolean value) {
        this.backingStore.set("isOcrEnabled", (Object)value);
    }

    public void setItemMajorVersionLimit(@Nullable Integer value) {
        this.backingStore.set("itemMajorVersionLimit", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }
}

