/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChangeTrackedEntity;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DayNote
extends ChangeTrackedEntity
implements Parsable {
    public DayNote() {
        this.setOdataType("#microsoft.graph.dayNote");
    }

    @Nonnull
    public static DayNote createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DayNote();
    }

    @Nullable
    public LocalDate getDayNoteDate() {
        return (LocalDate)this.backingStore.get("dayNoteDate");
    }

    @Nullable
    public ItemBody getDraftDayNote() {
        return (ItemBody)this.backingStore.get("draftDayNote");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("dayNoteDate", n -> this.setDayNoteDate(n.getLocalDateValue()));
        deserializerMap.put("draftDayNote", n -> this.setDraftDayNote((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("sharedDayNote", n -> this.setSharedDayNote((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getSharedDayNote() {
        return (ItemBody)this.backingStore.get("sharedDayNote");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeLocalDateValue("dayNoteDate", this.getDayNoteDate());
        writer.writeObjectValue("draftDayNote", (Parsable)this.getDraftDayNote(), new Parsable[0]);
        writer.writeObjectValue("sharedDayNote", (Parsable)this.getSharedDayNote(), new Parsable[0]);
    }

    public void setDayNoteDate(@Nullable LocalDate value) {
        this.backingStore.set("dayNoteDate", (Object)value);
    }

    public void setDraftDayNote(@Nullable ItemBody value) {
        this.backingStore.set("draftDayNote", (Object)value);
    }

    public void setSharedDayNote(@Nullable ItemBody value) {
        this.backingStore.set("sharedDayNote", (Object)value);
    }
}

