/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Call;
import com.microsoft.graph.models.OnlineMeeting;
import com.microsoft.graph.models.Presence;
import com.microsoft.graph.models.callrecords.CallRecord;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CloudCommunications
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public CloudCommunications() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static CloudCommunications createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CloudCommunications();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<CallRecord> getCallRecords() {
        return (List)this.backingStore.get("callRecords");
    }

    @Nullable
    public List<Call> getCalls() {
        return (List)this.backingStore.get("calls");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("callRecords", n -> this.setCallRecords(n.getCollectionOfObjectValues(CallRecord::createFromDiscriminatorValue)));
        deserializerMap.put("calls", n -> this.setCalls(n.getCollectionOfObjectValues(Call::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("onlineMeetings", n -> this.setOnlineMeetings(n.getCollectionOfObjectValues(OnlineMeeting::createFromDiscriminatorValue)));
        deserializerMap.put("presences", n -> this.setPresences(n.getCollectionOfObjectValues(Presence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<OnlineMeeting> getOnlineMeetings() {
        return (List)this.backingStore.get("onlineMeetings");
    }

    @Nullable
    public List<Presence> getPresences() {
        return (List)this.backingStore.get("presences");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("callRecords", this.getCallRecords());
        writer.writeCollectionOfObjectValues("calls", this.getCalls());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("onlineMeetings", this.getOnlineMeetings());
        writer.writeCollectionOfObjectValues("presences", this.getPresences());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCallRecords(@Nullable List<CallRecord> value) {
        this.backingStore.set("callRecords", value);
    }

    public void setCalls(@Nullable List<Call> value) {
        this.backingStore.set("calls", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOnlineMeetings(@Nullable List<OnlineMeeting> value) {
        this.backingStore.set("onlineMeetings", value);
    }

    public void setPresences(@Nullable List<Presence> value) {
        this.backingStore.set("presences", value);
    }
}

