/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BrowserSiteCompatibilityMode;
import com.microsoft.graph.models.BrowserSiteMergeType;
import com.microsoft.graph.models.BrowserSiteTargetEnvironment;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BrowserSiteHistory
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public BrowserSiteHistory() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static BrowserSiteHistory createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BrowserSiteHistory();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public Boolean getAllowRedirect() {
        return (Boolean)this.backingStore.get("allowRedirect");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getComment() {
        return (String)this.backingStore.get("comment");
    }

    @Nullable
    public BrowserSiteCompatibilityMode getCompatibilityMode() {
        return (BrowserSiteCompatibilityMode)((Object)this.backingStore.get("compatibilityMode"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("allowRedirect", n -> this.setAllowRedirect(n.getBooleanValue()));
        deserializerMap.put("comment", n -> this.setComment(n.getStringValue()));
        deserializerMap.put("compatibilityMode", n -> this.setCompatibilityMode((BrowserSiteCompatibilityMode)n.getEnumValue(BrowserSiteCompatibilityMode::forValue)));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("mergeType", n -> this.setMergeType((BrowserSiteMergeType)n.getEnumValue(BrowserSiteMergeType::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("publishedDateTime", n -> this.setPublishedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("targetEnvironment", n -> this.setTargetEnvironment((BrowserSiteTargetEnvironment)n.getEnumValue(BrowserSiteTargetEnvironment::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public BrowserSiteMergeType getMergeType() {
        return (BrowserSiteMergeType)((Object)this.backingStore.get("mergeType"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getPublishedDateTime() {
        return (OffsetDateTime)this.backingStore.get("publishedDateTime");
    }

    @Nullable
    public BrowserSiteTargetEnvironment getTargetEnvironment() {
        return (BrowserSiteTargetEnvironment)((Object)this.backingStore.get("targetEnvironment"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("allowRedirect", this.getAllowRedirect());
        writer.writeStringValue("comment", this.getComment());
        writer.writeEnumValue("compatibilityMode", (Enum)this.getCompatibilityMode());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeEnumValue("mergeType", (Enum)this.getMergeType());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeEnumValue("targetEnvironment", (Enum)this.getTargetEnvironment());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowRedirect(@Nullable Boolean value) {
        this.backingStore.set("allowRedirect", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setComment(@Nullable String value) {
        this.backingStore.set("comment", (Object)value);
    }

    public void setCompatibilityMode(@Nullable BrowserSiteCompatibilityMode value) {
        this.backingStore.set("compatibilityMode", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setMergeType(@Nullable BrowserSiteMergeType value) {
        this.backingStore.set("mergeType", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPublishedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", (Object)value);
    }

    public void setTargetEnvironment(@Nullable BrowserSiteTargetEnvironment value) {
        this.backingStore.set("targetEnvironment", (Object)value);
    }
}

