/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IdentityProvider;
import com.microsoft.graph.models.IdentityProviderBase;
import com.microsoft.graph.models.IdentityUserFlow;
import com.microsoft.graph.models.IdentityUserFlowAttributeAssignment;
import com.microsoft.graph.models.UserFlowApiConnectorConfiguration;
import com.microsoft.graph.models.UserFlowLanguageConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class B2xIdentityUserFlow
extends IdentityUserFlow
implements Parsable {
    @Nonnull
    public static B2xIdentityUserFlow createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new B2xIdentityUserFlow();
    }

    @Nullable
    public UserFlowApiConnectorConfiguration getApiConnectorConfiguration() {
        return (UserFlowApiConnectorConfiguration)this.backingStore.get("apiConnectorConfiguration");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("apiConnectorConfiguration", n -> this.setApiConnectorConfiguration((UserFlowApiConnectorConfiguration)n.getObjectValue(UserFlowApiConnectorConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("identityProviders", n -> this.setIdentityProviders(n.getCollectionOfObjectValues(IdentityProvider::createFromDiscriminatorValue)));
        deserializerMap.put("languages", n -> this.setLanguages(n.getCollectionOfObjectValues(UserFlowLanguageConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("userAttributeAssignments", n -> this.setUserAttributeAssignments(n.getCollectionOfObjectValues(IdentityUserFlowAttributeAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("userFlowIdentityProviders", n -> this.setUserFlowIdentityProviders(n.getCollectionOfObjectValues(IdentityProviderBase::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<IdentityProvider> getIdentityProviders() {
        return (List)this.backingStore.get("identityProviders");
    }

    @Nullable
    public List<UserFlowLanguageConfiguration> getLanguages() {
        return (List)this.backingStore.get("languages");
    }

    @Nullable
    public List<IdentityUserFlowAttributeAssignment> getUserAttributeAssignments() {
        return (List)this.backingStore.get("userAttributeAssignments");
    }

    @Nullable
    public List<IdentityProviderBase> getUserFlowIdentityProviders() {
        return (List)this.backingStore.get("userFlowIdentityProviders");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("apiConnectorConfiguration", (Parsable)this.getApiConnectorConfiguration(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("identityProviders", this.getIdentityProviders());
        writer.writeCollectionOfObjectValues("languages", this.getLanguages());
        writer.writeCollectionOfObjectValues("userAttributeAssignments", this.getUserAttributeAssignments());
        writer.writeCollectionOfObjectValues("userFlowIdentityProviders", this.getUserFlowIdentityProviders());
    }

    public void setApiConnectorConfiguration(@Nullable UserFlowApiConnectorConfiguration value) {
        this.backingStore.set("apiConnectorConfiguration", (Object)value);
    }

    public void setIdentityProviders(@Nullable List<IdentityProvider> value) {
        this.backingStore.set("identityProviders", value);
    }

    public void setLanguages(@Nullable List<UserFlowLanguageConfiguration> value) {
        this.backingStore.set("languages", value);
    }

    public void setUserAttributeAssignments(@Nullable List<IdentityUserFlowAttributeAssignment> value) {
        this.backingStore.set("userAttributeAssignments", value);
    }

    public void setUserFlowIdentityProviders(@Nullable List<IdentityProviderBase> value) {
        this.backingStore.set("userFlowIdentityProviders", value);
    }
}

