/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.models.AuthenticationMethodsPolicyMigrationState;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.RegistrationEnforcement;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AuthenticationMethodsPolicy
extends Entity
implements Parsable {
    @Nonnull
    public static AuthenticationMethodsPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AuthenticationMethodsPolicy();
    }

    @Nullable
    public List<AuthenticationMethodConfiguration> getAuthenticationMethodConfigurations() {
        return (List)this.backingStore.get("authenticationMethodConfigurations");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("authenticationMethodConfigurations", n -> this.setAuthenticationMethodConfigurations(n.getCollectionOfObjectValues(AuthenticationMethodConfiguration::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("policyMigrationState", n -> this.setPolicyMigrationState((AuthenticationMethodsPolicyMigrationState)n.getEnumValue(AuthenticationMethodsPolicyMigrationState::forValue)));
        deserializerMap.put("policyVersion", n -> this.setPolicyVersion(n.getStringValue()));
        deserializerMap.put("reconfirmationInDays", n -> this.setReconfirmationInDays(n.getIntegerValue()));
        deserializerMap.put("registrationEnforcement", n -> this.setRegistrationEnforcement((RegistrationEnforcement)n.getObjectValue(RegistrationEnforcement::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public AuthenticationMethodsPolicyMigrationState getPolicyMigrationState() {
        return (AuthenticationMethodsPolicyMigrationState)((Object)this.backingStore.get("policyMigrationState"));
    }

    @Nullable
    public String getPolicyVersion() {
        return (String)this.backingStore.get("policyVersion");
    }

    @Nullable
    public Integer getReconfirmationInDays() {
        return (Integer)this.backingStore.get("reconfirmationInDays");
    }

    @Nullable
    public RegistrationEnforcement getRegistrationEnforcement() {
        return (RegistrationEnforcement)this.backingStore.get("registrationEnforcement");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("authenticationMethodConfigurations", this.getAuthenticationMethodConfigurations());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("policyMigrationState", (Enum)this.getPolicyMigrationState());
        writer.writeStringValue("policyVersion", this.getPolicyVersion());
        writer.writeIntegerValue("reconfirmationInDays", this.getReconfirmationInDays());
        writer.writeObjectValue("registrationEnforcement", (Parsable)this.getRegistrationEnforcement(), new Parsable[0]);
    }

    public void setAuthenticationMethodConfigurations(@Nullable List<AuthenticationMethodConfiguration> value) {
        this.backingStore.set("authenticationMethodConfigurations", value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setPolicyMigrationState(@Nullable AuthenticationMethodsPolicyMigrationState value) {
        this.backingStore.set("policyMigrationState", (Object)value);
    }

    public void setPolicyVersion(@Nullable String value) {
        this.backingStore.set("policyVersion", (Object)value);
    }

    public void setReconfirmationInDays(@Nullable Integer value) {
        this.backingStore.set("reconfirmationInDays", (Object)value);
    }

    public void setRegistrationEnforcement(@Nullable RegistrationEnforcement value) {
        this.backingStore.set("registrationEnforcement", (Object)value);
    }
}

