/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AlertFeedback;
import com.microsoft.graph.models.AlertStatus;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AlertHistoryState
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AlertHistoryState() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AlertHistoryState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AlertHistoryState();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAppId() {
        return (String)this.backingStore.get("appId");
    }

    @Nullable
    public String getAssignedTo() {
        return (String)this.backingStore.get("assignedTo");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<String> getComments() {
        return (List)this.backingStore.get("comments");
    }

    @Nullable
    public AlertFeedback getFeedback() {
        return (AlertFeedback)((Object)this.backingStore.get("feedback"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("appId", n -> this.setAppId(n.getStringValue()));
        deserializerMap.put("assignedTo", n -> this.setAssignedTo(n.getStringValue()));
        deserializerMap.put("comments", n -> this.setComments(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("feedback", n -> this.setFeedback((AlertFeedback)n.getEnumValue(AlertFeedback::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((AlertStatus)n.getEnumValue(AlertStatus::forValue)));
        deserializerMap.put("updatedDateTime", n -> this.setUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("user", n -> this.setUser(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public AlertStatus getStatus() {
        return (AlertStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public OffsetDateTime getUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("updatedDateTime");
    }

    @Nullable
    public String getUser() {
        return (String)this.backingStore.get("user");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("appId", this.getAppId());
        writer.writeStringValue("assignedTo", this.getAssignedTo());
        writer.writeCollectionOfPrimitiveValues("comments", this.getComments());
        writer.writeEnumValue("feedback", (Enum)this.getFeedback());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeOffsetDateTimeValue("updatedDateTime", this.getUpdatedDateTime());
        writer.writeStringValue("user", this.getUser());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAppId(@Nullable String value) {
        this.backingStore.set("appId", (Object)value);
    }

    public void setAssignedTo(@Nullable String value) {
        this.backingStore.set("assignedTo", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setComments(@Nullable List<String> value) {
        this.backingStore.set("comments", value);
    }

    public void setFeedback(@Nullable AlertFeedback value) {
        this.backingStore.set("feedback", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStatus(@Nullable AlertStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("updatedDateTime", (Object)value);
    }

    public void setUser(@Nullable String value) {
        this.backingStore.set("user", (Object)value);
    }
}

