/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class PeriodAndDuration
implements TemporalAmount,
Comparable<PeriodAndDuration>,
Serializable {
    public static final PeriodAndDuration ZERO = new PeriodAndDuration(Period.ZERO, Duration.ZERO);
    private final Period period;
    private final Duration duration;
    private static final List<TemporalUnit> UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.NANOS));

    @Nonnull
    public Period getPeriod() {
        return this.period;
    }

    @Nonnull
    public Duration getDuration() {
        return this.duration;
    }

    private PeriodAndDuration(@Nonnull Period period, @Nonnull Duration duration) {
        Objects.requireNonNull(period, "parameter period cannot be null");
        Objects.requireNonNull(duration, "parameter duration cannot be null");
        this.period = period;
        this.duration = duration;
    }

    @Nonnull
    public static PeriodAndDuration of(@Nonnull Period period, @Nonnull Duration duration) {
        Objects.requireNonNull(period, "parameter period cannot be null");
        Objects.requireNonNull(duration, "parameter duration cannot be null");
        return new PeriodAndDuration(period, duration);
    }

    @Nonnull
    public static PeriodAndDuration ofPeriod(@Nonnull Period period) {
        Objects.requireNonNull(period, "parameter period cannot be null");
        return new PeriodAndDuration(period, Duration.ZERO);
    }

    @Nonnull
    public static PeriodAndDuration ofDuration(@Nonnull Duration duration) {
        Objects.requireNonNull(duration, "parameter duration cannot be null");
        return new PeriodAndDuration(Period.ZERO, duration);
    }

    @Nonnull
    public static PeriodAndDuration ofPeriodAndDuration(@Nonnull PeriodAndDuration periodAndDuration) {
        Objects.requireNonNull(periodAndDuration, "parameter periodAndDuration cannot be null");
        return new PeriodAndDuration(periodAndDuration.getPeriod(), periodAndDuration.getDuration());
    }

    @Nonnull
    public static PeriodAndDuration parse(@Nonnull String stringValue) {
        Objects.requireNonNull(stringValue, "parameter stringValue cannot be null");
        if (stringValue.substring(0, 3).contains("PT")) {
            return PeriodAndDuration.ofDuration(Duration.parse(stringValue));
        }
        int timePosition = stringValue.indexOf("T");
        if (timePosition < 0) {
            return PeriodAndDuration.ofPeriod(Period.parse(stringValue));
        }
        String sign = "";
        if (stringValue.charAt(0) == '-') {
            sign = "-";
        }
        Period period = Period.parse(stringValue.substring(0, timePosition));
        Duration duration = Duration.parse(sign + "P" + stringValue.substring(timePosition));
        return PeriodAndDuration.of(period, duration);
    }

    @Override
    public int compareTo(@Nonnull PeriodAndDuration periodAndDuration) {
        Objects.requireNonNull(periodAndDuration, "parameter periodAndDuration cannot be null");
        if (this.equals(periodAndDuration)) {
            return 0;
        }
        if (this.period.equals(periodAndDuration.getPeriod())) {
            return this.duration.compareTo(periodAndDuration.getDuration());
        }
        if (this.period.minus(periodAndDuration.getPeriod()).isNegative()) {
            return -1;
        }
        return 1;
    }

    @Override
    public long get(@Nonnull TemporalUnit unit) {
        Objects.requireNonNull(unit, "parameter unit cannot be null");
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case YEARS: {
                    return this.period.getYears();
                }
                case MONTHS: {
                    return this.period.getMonths();
                }
                case DAYS: {
                    return this.period.getDays();
                }
                case HOURS: {
                    return this.duration.toHours() % 24L;
                }
                case MINUTES: {
                    return this.duration.toMinutes() % 60L;
                }
                case SECONDS: {
                    return this.duration.getSeconds() % 60L;
                }
                case NANOS: {
                    return this.duration.getNano();
                }
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported TemporalUnit of type: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return new ArrayList<TemporalUnit>(UNITS);
    }

    @Override
    public Temporal addTo(@Nonnull Temporal temporal) {
        Objects.requireNonNull(temporal, "parameter temporal cannot be null");
        return temporal.plus(this.period).plus(this.duration);
    }

    @Override
    public Temporal subtractFrom(@Nonnull Temporal temporal) {
        Objects.requireNonNull(temporal, "parameter temporal cannot be null");
        return temporal.minus(this.period).minus(this.duration);
    }

    public String toString() {
        if (this.period.isZero()) {
            return this.duration.toString();
        }
        if (this.duration.isZero()) {
            return this.period.toString();
        }
        return this.period + this.duration.toString().substring(1);
    }

    public int hashCode() {
        return this.period.hashCode() + this.duration.hashCode();
    }

    public boolean equals(Object otherPeriodAndDuration) {
        if (this == otherPeriodAndDuration) {
            return true;
        }
        if (otherPeriodAndDuration instanceof PeriodAndDuration) {
            PeriodAndDuration otherInstance = (PeriodAndDuration)otherPeriodAndDuration;
            return this.period.equals(otherInstance.period) && this.duration.equals(otherInstance.duration);
        }
        return false;
    }
}

