/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.KiotaSerialization;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class KiotaJsonSerialization {
    private static final String CONTENT_TYPE = "application/json";

    private KiotaJsonSerialization() {
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull T value) throws IOException {
        return KiotaSerialization.serializeAsStream(CONTENT_TYPE, value);
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull T value, boolean serializeOnlyChangedValues) throws IOException {
        return KiotaSerialization.serializeAsStream(CONTENT_TYPE, value, serializeOnlyChangedValues);
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull T value) throws IOException {
        return KiotaSerialization.serializeAsString(CONTENT_TYPE, value);
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull T value, boolean serializeOnlyChangedValues) throws IOException {
        return KiotaSerialization.serializeAsString(CONTENT_TYPE, value, serializeOnlyChangedValues);
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull Iterable<T> values) throws IOException {
        return KiotaSerialization.serializeAsStream(CONTENT_TYPE, values);
    }

    @Nonnull
    public static <T extends Parsable> InputStream serializeAsStream(@Nonnull Iterable<T> values, boolean serializeOnlyChangedValues) throws IOException {
        return KiotaSerialization.serializeAsStream(CONTENT_TYPE, values, serializeOnlyChangedValues);
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull Iterable<T> values) throws IOException {
        return KiotaSerialization.serializeAsString(CONTENT_TYPE, values);
    }

    @Nonnull
    public static <T extends Parsable> String serializeAsString(@Nonnull Iterable<T> values, boolean serializeOnlyChangedValues) throws IOException {
        return KiotaSerialization.serializeAsString(CONTENT_TYPE, values, serializeOnlyChangedValues);
    }

    @Nonnull
    public static <T extends Parsable> T deserialize(@Nonnull InputStream stream, @Nonnull ParsableFactory<T> parsableFactory) {
        return KiotaSerialization.deserialize(CONTENT_TYPE, stream, parsableFactory);
    }

    @Nonnull
    public static <T extends Parsable> T deserialize(@Nonnull String value, @Nonnull ParsableFactory<T> parsableFactory) throws IOException {
        return KiotaSerialization.deserialize(CONTENT_TYPE, value, parsableFactory);
    }

    @Nonnull
    public static <T extends Parsable> List<T> deserializeCollection(@Nonnull String value, @Nonnull ParsableFactory<T> parsableFactory) throws IOException {
        return KiotaSerialization.deserializeCollection(CONTENT_TYPE, value, parsableFactory);
    }

    @Nonnull
    public static <T extends Parsable> List<T> deserializeCollection(@Nonnull InputStream stream, @Nonnull ParsableFactory<T> parsableFactory) {
        return KiotaSerialization.deserializeCollection(CONTENT_TYPE, stream, parsableFactory);
    }
}

