/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import com.microsoft.kiota.http.ContinuousAccessEvaluationClaims;
import com.microsoft.kiota.http.ObservabilityOptions;
import com.microsoft.kiota.http.TelemetrySemanticConventions;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AuthorizationHandler
implements Interceptor {
    @Nonnull
    private final BaseBearerTokenAuthenticationProvider authenticationProvider;
    private static final String AUTHORIZATION_HEADER = "Authorization";

    public AuthorizationHandler(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = Objects.requireNonNull(authenticationProvider, "AuthenticationProvider cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        Span span = GlobalOpenTelemetry.getTracer((String)new ObservabilityOptions().getTracerInstrumentationName()).spanBuilder("AuthorizationHandler_Intercept").startSpan();
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.authorization.enable", true);
        }
        try {
            RequestBody requestBody;
            if (request.headers().names().contains(AUTHORIZATION_HEADER)) {
                if (span != null) {
                    span.setAttribute("com.microsoft.kiota.handler.authorization.token_present", true);
                }
                Response response = chain.proceed(request);
                return response;
            }
            HashMap<String, Object> additionalContext = new HashMap<String, Object>();
            additionalContext.put("parent-span", span);
            Request authenticatedRequest = this.authenticateRequest(request, additionalContext, span);
            Response response = chain.proceed(authenticatedRequest);
            if (response != null && response.code() != 401) {
                Response response2 = response;
                return response2;
            }
            String claims = ContinuousAccessEvaluationClaims.getClaimsFromResponse(response);
            if (claims == null || claims.isEmpty()) {
                Response response3 = response;
                return response3;
            }
            if (span != null) {
                span.addEvent("com.microsoft.kiota.handler.authorization.challenge_received");
            }
            if ((requestBody = request.body()) != null && requestBody.isOneShot()) {
                Response response4 = response;
                return response4;
            }
            response.close();
            additionalContext.put("claims", claims);
            if (span != null) {
                span.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_RESEND_COUNT, 1);
            }
            Request authenticatedRequestAfterCAE = this.authenticateRequest(request, additionalContext, span);
            Response response5 = chain.proceed(authenticatedRequestAfterCAE);
            return response5;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
    }

    @Nonnull
    private Request authenticateRequest(@Nonnull Request request, @Nullable Map<String, Object> additionalAuthenticationContext, Span span) {
        AccessTokenProvider accessTokenProvider = this.authenticationProvider.getAccessTokenProvider();
        if (!accessTokenProvider.getAllowedHostsValidator().isUrlHostValid(request.url().uri())) {
            return request;
        }
        String accessToken = accessTokenProvider.getAuthorizationToken(request.url().uri(), additionalAuthenticationContext);
        if (accessToken != null && !accessToken.isEmpty()) {
            span.setAttribute("com.microsoft.kiota.handler.authorization.token_obtained", true);
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.addHeader(AUTHORIZATION_HEADER, "Bearer " + accessToken);
            return requestBuilder.build();
        }
        return request;
    }
}

