/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.labels.retentionlabels.item.descriptors;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.models.security.FilePlanDescriptor;
import com.microsoft.graph.security.labels.retentionlabels.item.descriptors.authoritytemplate.AuthorityTemplateRequestBuilder;
import com.microsoft.graph.security.labels.retentionlabels.item.descriptors.categorytemplate.CategoryTemplateRequestBuilder;
import com.microsoft.graph.security.labels.retentionlabels.item.descriptors.citationtemplate.CitationTemplateRequestBuilder;
import com.microsoft.graph.security.labels.retentionlabels.item.descriptors.departmenttemplate.DepartmentTemplateRequestBuilder;
import com.microsoft.graph.security.labels.retentionlabels.item.descriptors.fileplanreferencetemplate.FilePlanReferenceTemplateRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DescriptorsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AuthorityTemplateRequestBuilder authorityTemplate() {
        return new AuthorityTemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CategoryTemplateRequestBuilder categoryTemplate() {
        return new CategoryTemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CitationTemplateRequestBuilder citationTemplate() {
        return new CitationTemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public DepartmentTemplateRequestBuilder departmentTemplate() {
        return new DepartmentTemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public FilePlanReferenceTemplateRequestBuilder filePlanReferenceTemplate() {
        return new FilePlanReferenceTemplateRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public DescriptorsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/labels/retentionLabels/{retentionLabel%2Did}/descriptors{?%24expand,%24select}", pathParameters);
    }

    public DescriptorsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/labels/retentionLabels/{retentionLabel%2Did}/descriptors{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public FilePlanDescriptor get() {
        return this.get(null);
    }

    @Nullable
    public FilePlanDescriptor get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (FilePlanDescriptor)this.requestAdapter.send(requestInfo, errorMapping, FilePlanDescriptor::createFromDiscriminatorValue);
    }

    @Nullable
    public FilePlanDescriptor patch(@Nonnull FilePlanDescriptor body) {
        return this.patch(body, null);
    }

    @Nullable
    public FilePlanDescriptor patch(@Nonnull FilePlanDescriptor body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (FilePlanDescriptor)this.requestAdapter.send(requestInfo, errorMapping, FilePlanDescriptor::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull FilePlanDescriptor body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull FilePlanDescriptor body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public DescriptorsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new DescriptorsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

