/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.search.query;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.search.query.QueryPostRequestBody;
import com.microsoft.graph.search.query.QueryPostResponse;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class QueryRequestBuilder
extends BaseRequestBuilder {
    public QueryRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/query", pathParameters);
    }

    public QueryRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/search/query", rawUrl);
    }

    @Nullable
    public QueryPostResponse post(@Nonnull QueryPostRequestBody body) {
        return this.post(body, null);
    }

    @Nullable
    public QueryPostResponse post(@Nonnull QueryPostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (QueryPostResponse)this.requestAdapter.send(requestInfo, errorMapping, QueryPostResponse::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull QueryPostRequestBody body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull QueryPostRequestBody body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public QueryRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new QueryRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

