/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Channel;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import com.microsoft.graph.models.Schedule;
import com.microsoft.graph.models.TeamFunSettings;
import com.microsoft.graph.models.TeamGuestSettings;
import com.microsoft.graph.models.TeamMemberSettings;
import com.microsoft.graph.models.TeamMessagingSettings;
import com.microsoft.graph.models.TeamSpecialization;
import com.microsoft.graph.models.TeamSummary;
import com.microsoft.graph.models.TeamVisibilityType;
import com.microsoft.graph.models.TeamsAppInstallation;
import com.microsoft.graph.models.TeamsAsyncOperation;
import com.microsoft.graph.models.TeamsTemplate;
import com.microsoft.graph.models.TeamworkTag;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Team
extends Entity
implements Parsable {
    @Nonnull
    public static Team createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Team();
    }

    @Nullable
    public List<Channel> getAllChannels() {
        return (List)this.backingStore.get("allChannels");
    }

    @Nullable
    public List<Channel> getChannels() {
        return (List)this.backingStore.get("channels");
    }

    @Nullable
    public String getClassification() {
        return (String)this.backingStore.get("classification");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allChannels", n -> this.setAllChannels(n.getCollectionOfObjectValues(Channel::createFromDiscriminatorValue)));
        deserializerMap.put("channels", n -> this.setChannels(n.getCollectionOfObjectValues(Channel::createFromDiscriminatorValue)));
        deserializerMap.put("classification", n -> this.setClassification(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("firstChannelName", n -> this.setFirstChannelName(n.getStringValue()));
        deserializerMap.put("funSettings", n -> this.setFunSettings((TeamFunSettings)n.getObjectValue(TeamFunSettings::createFromDiscriminatorValue)));
        deserializerMap.put("group", n -> this.setGroup((Group)n.getObjectValue(Group::createFromDiscriminatorValue)));
        deserializerMap.put("guestSettings", n -> this.setGuestSettings((TeamGuestSettings)n.getObjectValue(TeamGuestSettings::createFromDiscriminatorValue)));
        deserializerMap.put("incomingChannels", n -> this.setIncomingChannels(n.getCollectionOfObjectValues(Channel::createFromDiscriminatorValue)));
        deserializerMap.put("installedApps", n -> this.setInstalledApps(n.getCollectionOfObjectValues(TeamsAppInstallation::createFromDiscriminatorValue)));
        deserializerMap.put("internalId", n -> this.setInternalId(n.getStringValue()));
        deserializerMap.put("isArchived", n -> this.setIsArchived(n.getBooleanValue()));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(ConversationMember::createFromDiscriminatorValue)));
        deserializerMap.put("memberSettings", n -> this.setMemberSettings((TeamMemberSettings)n.getObjectValue(TeamMemberSettings::createFromDiscriminatorValue)));
        deserializerMap.put("messagingSettings", n -> this.setMessagingSettings((TeamMessagingSettings)n.getObjectValue(TeamMessagingSettings::createFromDiscriminatorValue)));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(TeamsAsyncOperation::createFromDiscriminatorValue)));
        deserializerMap.put("permissionGrants", n -> this.setPermissionGrants(n.getCollectionOfObjectValues(ResourceSpecificPermissionGrant::createFromDiscriminatorValue)));
        deserializerMap.put("photo", n -> this.setPhoto((ProfilePhoto)n.getObjectValue(ProfilePhoto::createFromDiscriminatorValue)));
        deserializerMap.put("primaryChannel", n -> this.setPrimaryChannel((Channel)n.getObjectValue(Channel::createFromDiscriminatorValue)));
        deserializerMap.put("schedule", n -> this.setSchedule((Schedule)n.getObjectValue(Schedule::createFromDiscriminatorValue)));
        deserializerMap.put("specialization", n -> this.setSpecialization((TeamSpecialization)n.getEnumValue(TeamSpecialization::forValue)));
        deserializerMap.put("summary", n -> this.setSummary((TeamSummary)n.getObjectValue(TeamSummary::createFromDiscriminatorValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfObjectValues(TeamworkTag::createFromDiscriminatorValue)));
        deserializerMap.put("template", n -> this.setTemplate((TeamsTemplate)n.getObjectValue(TeamsTemplate::createFromDiscriminatorValue)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        deserializerMap.put("visibility", n -> this.setVisibility((TeamVisibilityType)n.getEnumValue(TeamVisibilityType::forValue)));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getFirstChannelName() {
        return (String)this.backingStore.get("firstChannelName");
    }

    @Nullable
    public TeamFunSettings getFunSettings() {
        return (TeamFunSettings)this.backingStore.get("funSettings");
    }

    @Nullable
    public Group getGroup() {
        return (Group)this.backingStore.get("group");
    }

    @Nullable
    public TeamGuestSettings getGuestSettings() {
        return (TeamGuestSettings)this.backingStore.get("guestSettings");
    }

    @Nullable
    public List<Channel> getIncomingChannels() {
        return (List)this.backingStore.get("incomingChannels");
    }

    @Nullable
    public List<TeamsAppInstallation> getInstalledApps() {
        return (List)this.backingStore.get("installedApps");
    }

    @Nullable
    public String getInternalId() {
        return (String)this.backingStore.get("internalId");
    }

    @Nullable
    public Boolean getIsArchived() {
        return (Boolean)this.backingStore.get("isArchived");
    }

    @Nullable
    public List<ConversationMember> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public TeamMemberSettings getMemberSettings() {
        return (TeamMemberSettings)this.backingStore.get("memberSettings");
    }

    @Nullable
    public TeamMessagingSettings getMessagingSettings() {
        return (TeamMessagingSettings)this.backingStore.get("messagingSettings");
    }

    @Nullable
    public List<TeamsAsyncOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public List<ResourceSpecificPermissionGrant> getPermissionGrants() {
        return (List)this.backingStore.get("permissionGrants");
    }

    @Nullable
    public ProfilePhoto getPhoto() {
        return (ProfilePhoto)this.backingStore.get("photo");
    }

    @Nullable
    public Channel getPrimaryChannel() {
        return (Channel)this.backingStore.get("primaryChannel");
    }

    @Nullable
    public Schedule getSchedule() {
        return (Schedule)this.backingStore.get("schedule");
    }

    @Nullable
    public TeamSpecialization getSpecialization() {
        return (TeamSpecialization)((Object)this.backingStore.get("specialization"));
    }

    @Nullable
    public TeamSummary getSummary() {
        return (TeamSummary)this.backingStore.get("summary");
    }

    @Nullable
    public List<TeamworkTag> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Nullable
    public TeamsTemplate getTemplate() {
        return (TeamsTemplate)this.backingStore.get("template");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Nullable
    public TeamVisibilityType getVisibility() {
        return (TeamVisibilityType)((Object)this.backingStore.get("visibility"));
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("allChannels", this.getAllChannels());
        writer.writeCollectionOfObjectValues("channels", this.getChannels());
        writer.writeStringValue("classification", this.getClassification());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("firstChannelName", this.getFirstChannelName());
        writer.writeObjectValue("funSettings", (Parsable)this.getFunSettings(), new Parsable[0]);
        writer.writeObjectValue("group", (Parsable)this.getGroup(), new Parsable[0]);
        writer.writeObjectValue("guestSettings", (Parsable)this.getGuestSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("incomingChannels", this.getIncomingChannels());
        writer.writeCollectionOfObjectValues("installedApps", this.getInstalledApps());
        writer.writeStringValue("internalId", this.getInternalId());
        writer.writeBooleanValue("isArchived", this.getIsArchived());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeObjectValue("memberSettings", (Parsable)this.getMemberSettings(), new Parsable[0]);
        writer.writeObjectValue("messagingSettings", (Parsable)this.getMessagingSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeCollectionOfObjectValues("permissionGrants", this.getPermissionGrants());
        writer.writeObjectValue("photo", (Parsable)this.getPhoto(), new Parsable[0]);
        writer.writeObjectValue("primaryChannel", (Parsable)this.getPrimaryChannel(), new Parsable[0]);
        writer.writeObjectValue("schedule", (Parsable)this.getSchedule(), new Parsable[0]);
        writer.writeEnumValue("specialization", (Enum)this.getSpecialization());
        writer.writeObjectValue("summary", (Parsable)this.getSummary(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("tags", this.getTags());
        writer.writeObjectValue("template", (Parsable)this.getTemplate(), new Parsable[0]);
        writer.writeStringValue("tenantId", this.getTenantId());
        writer.writeEnumValue("visibility", (Enum)this.getVisibility());
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setAllChannels(@Nullable List<Channel> value) {
        this.backingStore.set("allChannels", value);
    }

    public void setChannels(@Nullable List<Channel> value) {
        this.backingStore.set("channels", value);
    }

    public void setClassification(@Nullable String value) {
        this.backingStore.set("classification", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setFirstChannelName(@Nullable String value) {
        this.backingStore.set("firstChannelName", (Object)value);
    }

    public void setFunSettings(@Nullable TeamFunSettings value) {
        this.backingStore.set("funSettings", (Object)value);
    }

    public void setGroup(@Nullable Group value) {
        this.backingStore.set("group", (Object)value);
    }

    public void setGuestSettings(@Nullable TeamGuestSettings value) {
        this.backingStore.set("guestSettings", (Object)value);
    }

    public void setIncomingChannels(@Nullable List<Channel> value) {
        this.backingStore.set("incomingChannels", value);
    }

    public void setInstalledApps(@Nullable List<TeamsAppInstallation> value) {
        this.backingStore.set("installedApps", value);
    }

    public void setInternalId(@Nullable String value) {
        this.backingStore.set("internalId", (Object)value);
    }

    public void setIsArchived(@Nullable Boolean value) {
        this.backingStore.set("isArchived", (Object)value);
    }

    public void setMembers(@Nullable List<ConversationMember> value) {
        this.backingStore.set("members", value);
    }

    public void setMemberSettings(@Nullable TeamMemberSettings value) {
        this.backingStore.set("memberSettings", (Object)value);
    }

    public void setMessagingSettings(@Nullable TeamMessagingSettings value) {
        this.backingStore.set("messagingSettings", (Object)value);
    }

    public void setOperations(@Nullable List<TeamsAsyncOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setPermissionGrants(@Nullable List<ResourceSpecificPermissionGrant> value) {
        this.backingStore.set("permissionGrants", value);
    }

    public void setPhoto(@Nullable ProfilePhoto value) {
        this.backingStore.set("photo", (Object)value);
    }

    public void setPrimaryChannel(@Nullable Channel value) {
        this.backingStore.set("primaryChannel", (Object)value);
    }

    public void setSchedule(@Nullable Schedule value) {
        this.backingStore.set("schedule", (Object)value);
    }

    public void setSpecialization(@Nullable TeamSpecialization value) {
        this.backingStore.set("specialization", (Object)value);
    }

    public void setSummary(@Nullable TeamSummary value) {
        this.backingStore.set("summary", (Object)value);
    }

    public void setTags(@Nullable List<TeamworkTag> value) {
        this.backingStore.set("tags", value);
    }

    public void setTemplate(@Nullable TeamsTemplate value) {
        this.backingStore.set("template", (Object)value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }

    public void setVisibility(@Nullable TeamVisibilityType value) {
        this.backingStore.set("visibility", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

