/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PresenceStatusMessage
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PresenceStatusMessage() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PresenceStatusMessage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PresenceStatusMessage();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public DateTimeTimeZone getExpiryDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("expiryDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("expiryDateTime", n -> this.setExpiryDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("message", n -> this.setMessage((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("publishedDateTime", n -> this.setPublishedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getMessage() {
        return (ItemBody)this.backingStore.get("message");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getPublishedDateTime() {
        return (OffsetDateTime)this.backingStore.get("publishedDateTime");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("expiryDateTime", (Parsable)this.getExpiryDateTime(), new Parsable[0]);
        writer.writeObjectValue("message", (Parsable)this.getMessage(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("publishedDateTime", this.getPublishedDateTime());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setExpiryDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("expiryDateTime", (Object)value);
    }

    public void setMessage(@Nullable ItemBody value) {
        this.backingStore.set("message", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPublishedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("publishedDateTime", (Object)value);
    }
}

