/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import com.microsoft.kiota.store.BackingStoreSerializationWriterProxyFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;

public class SerializationWriterFactoryRegistry
implements SerializationWriterFactory {
    public static final SerializationWriterFactoryRegistry defaultInstance = new SerializationWriterFactoryRegistry();
    @Nonnull
    public final HashMap<String, SerializationWriterFactory> contentTypeAssociatedFactories = new HashMap();
    private static final Pattern contentTypeVendorCleanupPattern = Pattern.compile("[^/]+\\+", 2);

    @Override
    @Nonnull
    public String getValidContentType() {
        throw new UnsupportedOperationException("The registry supports multiple content types. Get the registered factory instead.");
    }

    @Override
    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        return this.getSerializationWriter(contentType, true);
    }

    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType, boolean serializeOnlyChangedValues) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        String cleanedContentType = this.getVendorSpecificContentType(contentType);
        SerializationWriterFactory factory = this.getSerializationWriterFactory(cleanedContentType);
        if (factory == null && (factory = this.getSerializationWriterFactory(this.getCleanedVendorSpecificContentType(cleanedContentType = this.getCleanedVendorSpecificContentType(cleanedContentType)))) == null) {
            throw new RuntimeException("Content type " + contentType + " does not have a factory to be serialized");
        }
        if (!serializeOnlyChangedValues && factory instanceof BackingStoreSerializationWriterProxyFactory) {
            return ((BackingStoreSerializationWriterProxyFactory)factory).getSerializationWriter(cleanedContentType, serializeOnlyChangedValues);
        }
        return factory.getSerializationWriter(cleanedContentType);
    }

    @Nullable
    private SerializationWriterFactory getSerializationWriterFactory(@Nonnull String contentType) {
        if (this.contentTypeAssociatedFactories.containsKey(contentType)) {
            return this.contentTypeAssociatedFactories.get(contentType);
        }
        return null;
    }

    @Nonnull
    private String getVendorSpecificContentType(@Nonnull String contentType) {
        String[] split = contentType.split(";");
        if (split.length >= 1) {
            return split[0];
        }
        return contentType;
    }

    @Nonnull
    private String getCleanedVendorSpecificContentType(@Nonnull String contentType) {
        return contentTypeVendorCleanupPattern.matcher(contentType).replaceAll("");
    }
}

