/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.size;

import java.util.Collections;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class SizeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_size";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new SizeFieldMapper((Explicit<Boolean>)Explicit.IMPLICIT_FALSE, (MappedFieldType)new SizeFieldType()), c -> new Builder());
    private final Explicit<Boolean> enabled;

    private static SizeFieldMapper toType(FieldMapper in) {
        return (SizeFieldMapper)in;
    }

    private SizeFieldMapper(Explicit<Boolean> enabled, MappedFieldType mappedFieldType) {
        super(mappedFieldType);
        this.enabled = enabled;
    }

    protected String contentType() {
        return NAME;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.value();
    }

    public void postParse(DocumentParserContext context) {
        if (!((Boolean)this.enabled.value()).booleanValue()) {
            return;
        }
        int value = context.sourceToParse().source().length();
        NumberFieldMapper.NumberType.INTEGER.addFields(context.doc(), this.fullPath(), (Number)value, true, true, true);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init((FieldMapper)this);
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam((String)"enabled", m -> SizeFieldMapper.toType((FieldMapper)m).enabled, (boolean)false);

        private Builder() {
            super(SizeFieldMapper.NAME);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled};
        }

        public SizeFieldMapper build() {
            return new SizeFieldMapper((Explicit<Boolean>)((Explicit)this.enabled.getValue()), (MappedFieldType)new SizeFieldType());
        }
    }

    private static class SizeFieldType
    extends NumberFieldMapper.NumberFieldType {
        SizeFieldType() {
            super(SizeFieldMapper.NAME, NumberFieldMapper.NumberType.INTEGER, true, true, true, false, null, Collections.emptyMap(), null, false, null, null);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (!this.hasDocValues()) {
                return ValueFetcher.EMPTY;
            }
            return new DocValueFetcher(this.docValueFormat(format, null), context.getForField((MappedFieldType)this, MappedFieldType.FielddataOperation.SEARCH));
        }
    }
}

