/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.size;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class SizeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_size";
    private EnabledAttributeMapper enabledState;

    private SizeFieldMapper(FieldType fieldType, EnabledAttributeMapper enabled, MappedFieldType mappedFieldType) {
        super(fieldType, mappedFieldType);
        this.enabledState = enabled;
    }

    protected String contentType() {
        return NAME;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public void preParse(ParseContext context) {
    }

    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    public void parse(ParseContext context) {
    }

    protected void parseCreateField(ParseContext context) {
        if (!this.enabledState.enabled) {
            return;
        }
        int value = context.sourceToParse().source().length();
        boolean indexed = this.fieldType().isSearchable();
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType.stored();
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.name(), (Number)value, indexed, docValued, stored));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED_STATE) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        builder.endObject();
        return builder;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        SizeFieldMapper sizeFieldMapperMergeWith = (SizeFieldMapper)other;
        if (sizeFieldMapperMergeWith.enabledState != this.enabledState && !sizeFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = sizeFieldMapperMergeWith.enabledState;
        }
    }

    public static class Defaults {
        public static final EnabledAttributeMapper ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        public static final FieldType SIZE_FIELD_TYPE = new FieldType();

        static {
            SIZE_FIELD_TYPE.setStored(true);
            SIZE_FIELD_TYPE.freeze();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                boolean enabled = XContentMapValues.nodeBooleanValue((Object)fieldNode, (String)(name + ".enabled"));
                builder.enabled(enabled ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED);
                iterator.remove();
            }
            return builder;
        }

        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            return new SizeFieldMapper(Defaults.SIZE_FIELD_TYPE, Defaults.ENABLED_STATE, (MappedFieldType)new NumberFieldMapper.NumberFieldType(SizeFieldMapper.NAME, NumberFieldMapper.NumberType.INTEGER));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder> {
        protected EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;

        private Builder() {
            super(SizeFieldMapper.NAME, Defaults.SIZE_FIELD_TYPE);
            this.builder = this;
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        public SizeFieldMapper build(Mapper.BuilderContext context) {
            return new SizeFieldMapper(this.fieldType, this.enabledState, (MappedFieldType)new NumberFieldMapper.NumberFieldType(SizeFieldMapper.NAME, NumberFieldMapper.NumberType.INTEGER));
        }
    }
}

