/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.size;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class SizeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_size";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new SizeFieldMapper((Explicit<Boolean>)new Explicit((Object)false, false), (MappedFieldType)new NumberFieldMapper.NumberFieldType(NAME, NumberFieldMapper.NumberType.INTEGER)), c -> new Builder());
    private final Explicit<Boolean> enabled;

    private static SizeFieldMapper toType(FieldMapper in) {
        return (SizeFieldMapper)in;
    }

    private SizeFieldMapper(Explicit<Boolean> enabled, MappedFieldType mappedFieldType) {
        super(mappedFieldType);
        this.enabled = enabled;
    }

    protected String contentType() {
        return NAME;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.value();
    }

    public void postParse(ParseContext context) throws IOException {
        if (!((Boolean)this.enabled.value()).booleanValue()) {
            return;
        }
        int value = context.sourceToParse().source().length();
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.name(), (Number)value, true, true, true));
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init((FieldMapper)this);
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = MetadataFieldMapper.updateableBoolParam((String)"enabled", m -> SizeFieldMapper.access$200(SizeFieldMapper.toType(m)), (boolean)false);

        private Builder() {
            super(SizeFieldMapper.NAME);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Collections.singletonList(this.enabled);
        }

        public SizeFieldMapper build() {
            return new SizeFieldMapper((Explicit)this.enabled.getValue(), (MappedFieldType)new NumberFieldMapper.NumberFieldType(SizeFieldMapper.NAME, NumberFieldMapper.NumberType.INTEGER));
        }
    }
}

