/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.size;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;

public class SizeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_size";
    private EnabledAttributeMapper enabledState;

    private static MappedFieldType defaultFieldType(Version indexCreated) {
        MappedFieldType defaultFieldType = Defaults.SIZE_FIELD_TYPE.clone();
        defaultFieldType.setHasDocValues(true);
        return defaultFieldType;
    }

    private SizeFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(Defaults.ENABLED_STATE, existing == null ? SizeFieldMapper.defaultFieldType(Version.indexCreated((Settings)indexSettings)) : existing.clone(), indexSettings);
    }

    private SizeFieldMapper(EnabledAttributeMapper enabled, MappedFieldType fieldType, Settings indexSettings) {
        super(NAME, fieldType, SizeFieldMapper.defaultFieldType(Version.indexCreated((Settings)indexSettings)), indexSettings);
        this.enabledState = enabled;
    }

    protected String contentType() {
        return NAME;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public void preParse(ParseContext context) throws IOException {
    }

    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        int value = context.sourceToParse().source().length();
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType().stored();
        fields.addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.name(), (Number)value, indexed, docValued, stored));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED_STATE) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        builder.endObject();
        return builder;
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        SizeFieldMapper sizeFieldMapperMergeWith = (SizeFieldMapper)mergeWith;
        if (sizeFieldMapperMergeWith.enabledState != this.enabledState && !sizeFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = sizeFieldMapperMergeWith.enabledState;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName(SizeFieldMapper.NAME), parserContext.indexVersionCreated());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                boolean enabled = TypeParsers.nodeBooleanValue((String)name, (String)"enabled", (Object)fieldNode, (Mapper.TypeParser.ParserContext)parserContext);
                builder.enabled(enabled ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED);
                iterator.remove();
            }
            return builder;
        }

        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new SizeFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, SizeFieldMapper> {
        protected EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;

        private Builder(MappedFieldType existing, Version indexCreated) {
            super(SizeFieldMapper.NAME, existing == null ? SizeFieldMapper.defaultFieldType(indexCreated) : existing.clone(), SizeFieldMapper.defaultFieldType(indexCreated));
            this.builder = this;
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        public SizeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            if (context.indexCreatedVersion().onOrBefore(Version.V_5_0_0_alpha4)) {
                this.fieldType.setHasDocValues(false);
            }
            return new SizeFieldMapper(this.enabledState, this.fieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final EnabledAttributeMapper ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        public static final MappedFieldType SIZE_FIELD_TYPE = new NumberFieldMapper.NumberFieldType(NumberFieldMapper.NumberType.INTEGER);

        static {
            SIZE_FIELD_TYPE.setStored(true);
            SIZE_FIELD_TYPE.setName(SizeFieldMapper.NAME);
            SIZE_FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            SIZE_FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            SIZE_FIELD_TYPE.setHasDocValues(true);
            SIZE_FIELD_TYPE.freeze();
        }
    }
}

