/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.murmur3;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class Murmur3FieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "murmur3";

    protected Murmur3FieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        Object value = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (value != null) {
            BytesRef bytes = new BytesRef((CharSequence)value.toString());
            long hash = MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), hash));
            if (this.fieldType.stored()) {
                context.doc().add((IndexableField)new StoredField(this.name(), hash));
            }
        }
    }

    protected boolean indexedByDefault() {
        return false;
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    public static class Murmur3FieldType
    extends MappedFieldType {
        public Murmur3FieldType(String name, Map<String, String> meta) {
            super(name, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
        }

        public String typeName() {
            return Murmur3FieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(IndexNumericFieldData.NumericType.LONG);
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Murmur3 fields are not searchable: [" + this.name() + "]", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            if (node.get("doc_values") != null) {
                throw new MapperParsingException("Setting [doc_values] cannot be modified for field [" + name + "]");
            }
            if (node.get("index") != null) {
                throw new MapperParsingException("Setting [index] cannot be modified for field [" + name + "]");
            }
            TypeParsers.parseField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Murmur3FieldMapper build(Mapper.BuilderContext context) {
            return new Murmur3FieldMapper(this.name, this.fieldType, new Murmur3FieldType(this.buildFullName(context), this.meta), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

