/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.murmur3;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class Murmur3FieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "murmur3";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));

    private static Murmur3FieldMapper toType(FieldMapper in) {
        return (Murmur3FieldMapper)in;
    }

    protected Murmur3FieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        Object value = context.externalValueSet() ? context.externalValue() : context.parser().textOrNull();
        if (value != null) {
            BytesRef bytes = new BytesRef((CharSequence)value.toString());
            long hash = MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
            context.doc().add((IndexableField)new SortedNumericDocValuesField(this.fieldType().name(), hash));
            if (this.fieldType().isStored()) {
                context.doc().add((IndexableField)new StoredField(this.name(), hash));
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> Murmur3FieldMapper.toType(m).fieldType().isStored(), (boolean)false);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.meta);
        }

        public Murmur3FieldMapper build(ContentPath contentPath) {
            return new Murmur3FieldMapper(this.name, new Murmur3FieldType(this.buildFullName(contentPath), (Boolean)this.stored.getValue(), (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build());
        }
    }

    public static class Murmur3FieldType
    extends MappedFieldType {
        private Murmur3FieldType(String name, boolean isStored, Map<String, String> meta) {
            super(name, false, isStored, true, TextSearchInfo.NONE, meta);
        }

        public String typeName() {
            return Murmur3FieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Murmur3 fields are not searchable: [" + this.name() + "]");
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }
}

