/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractOOXMLExtractor
implements OOXMLExtractor {
    static final String RELATION_AUDIO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio";
    static final String RELATION_IMAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    static final String RELATION_OLE_OBJECT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    static final String RELATION_PACKAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    static final String RELATION_MACRO = "http://schemas.microsoft.com/office/2006/relationships/vbaProject";
    static final String RELATION_OFFICE_DOCUMENT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    private static final String TYPE_OLE_OBJECT = "application/vnd.openxmlformats-officedocument.oleObject";
    private final EmbeddedDocumentExtractor embeddedExtractor;
    protected POIXMLTextExtractor extractor;

    public AbstractOOXMLExtractor(ParseContext context, POIXMLTextExtractor extractor) {
        this.extractor = extractor;
        EmbeddedDocumentExtractor ex = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class);
        this.embeddedExtractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
    }

    @Override
    public POIXMLDocument getDocument() {
        return this.extractor.getDocument();
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor(this.extractor);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.buildXHTML(xhtml);
        this.handleEmbeddedParts(handler);
        this.handleThumbnail(handler);
        xhtml.endDocument();
    }

    protected String getJustFileName(String desc) {
        int idx = desc.lastIndexOf(47);
        if (idx != -1) {
            desc = desc.substring(idx + 1);
        }
        if ((idx = desc.lastIndexOf(46)) != -1) {
            desc = desc.substring(0, idx);
        }
        return desc;
    }

    private void handleThumbnail(ContentHandler handler) {
        try {
            OPCPackage opcPackage = this.extractor.getPackage();
            for (PackageRelationship rel : opcPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail")) {
                PackagePart tPart = opcPackage.getPart(rel);
                InputStream tStream = tPart.getInputStream();
                Metadata thumbnailMetadata = new Metadata();
                String thumbName = tPart.getPartName().getName();
                thumbnailMetadata.set("resourceName", thumbName);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "id", "id", "CDATA", thumbName);
                handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
                handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
                thumbnailMetadata.set("embeddedRelationshipId", thumbName);
                thumbnailMetadata.set("Content-Type", tPart.getContentType());
                thumbnailMetadata.set(TikaCoreProperties.TITLE, tPart.getPartName().getName());
                if (this.embeddedExtractor.shouldParseEmbedded(thumbnailMetadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)TikaInputStream.get((InputStream)tStream), (ContentHandler)new EmbeddedContentHandler(handler), thumbnailMetadata, false);
                }
                tStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleEmbeddedParts(ContentHandler handler) throws TikaException, IOException, SAXException {
        try {
            for (PackagePart source : this.getMainDocumentParts()) {
                for (PackageRelationship rel : source.getRelationships()) {
                    PackagePart target;
                    String sourceDesc;
                    URI sourceURI = rel.getSourceURI();
                    sourceDesc = sourceURI != null ? ((sourceDesc = this.getJustFileName(sourceURI.getPath())).startsWith("slide") ? sourceDesc + "_" : "") : "";
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    try {
                        target = source.getRelatedPart(rel);
                    }
                    catch (IllegalArgumentException ex) {
                        continue;
                    }
                    String type = rel.getRelationshipType();
                    if (RELATION_OLE_OBJECT.equals(type) && TYPE_OLE_OBJECT.equals(target.getContentType())) {
                        this.handleEmbeddedOLE(target, handler, sourceDesc + rel.getId());
                        continue;
                    }
                    if (RELATION_AUDIO.equals(type) || RELATION_IMAGE.equals(type) || RELATION_PACKAGE.equals(type) || RELATION_OLE_OBJECT.equals(type)) {
                        this.handleEmbeddedFile(target, handler, sourceDesc + rel.getId());
                        continue;
                    }
                    if (!RELATION_MACRO.equals(type)) continue;
                    this.handleMacros(target, handler);
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Broken OOXML file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbeddedOLE(PackagePart part, ContentHandler handler, String rel) throws IOException, SAXException {
        if (part.getSize() >= 0L && part.getSize() < 1536L) {
            return;
        }
        POIFSFileSystem fs = new POIFSFileSystem(part.getInputStream());
        TikaInputStream stream = null;
        try {
            Metadata metadata = new Metadata();
            metadata.set("embeddedRelationshipId", rel);
            DirectoryNode root = fs.getRoot();
            OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType((DirectoryEntry)root);
            if (root.hasEntry("CONTENTS") && root.hasEntry("\u0001Ole") && root.hasEntry("\u0001CompObj")) {
                stream = TikaInputStream.get((InputStream)fs.createDocumentInputStream("CONTENTS"));
                if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
                }
            } else if (OfficeParser.POIFSDocumentType.OLE10_NATIVE == type) {
                byte[] data;
                Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((POIFSFileSystem)fs);
                if (ole.getLabel() != null) {
                    metadata.set("resourceName", ole.getLabel());
                }
                if (ole.getCommand() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
                }
                if (ole.getFileName() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
                }
                if ((data = ole.getDataBuffer()) != null) {
                    stream = TikaInputStream.get((byte[])data);
                }
                if (stream != null && this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
                }
            } else {
                this.handleEmbeddedFile(part, handler, rel);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Ole10NativeException ole10NativeException) {
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void handleEmbeddedFile(PackagePart part, ContentHandler handler, String rel) throws SAXException, IOException {
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", rel);
        String name = part.getPartName().getName();
        metadata.set("resourceName", name.substring(name.lastIndexOf(47) + 1));
        metadata.set("Content-Type", part.getContentType());
        if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
            try (TikaInputStream tis = TikaInputStream.get((InputStream)part.getInputStream());){
                this.embeddedExtractor.parseEmbedded((InputStream)tis, (ContentHandler)new EmbeddedContentHandler(handler), metadata, false);
            }
        }
    }

    protected abstract void buildXHTML(XHTMLContentHandler var1) throws SAXException, XmlException, IOException;

    protected abstract List<PackagePart> getMainDocumentParts() throws TikaException;

    void handleMacros(PackagePart macroPart, ContentHandler handler) throws TikaException, SAXException {
        try (InputStream is = macroPart.getInputStream();
             NPOIFSFileSystem npoifs = new NPOIFSFileSystem(is);){
            OfficeParser.extractMacros(npoifs, handler, this.embeddedExtractor);
        }
        catch (IOException e) {
            throw new TikaException("Broken OOXML file", (Throwable)e);
        }
    }
}

