/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.contenttype.parser.ContentTypeParser;
import org.apache.james.mime4j.field.contenttype.parser.ParseException;
import org.apache.james.mime4j.field.contenttype.parser.TokenMgrError;
import org.apache.james.mime4j.stream.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeFieldImpl
extends AbstractField
implements ContentTypeField {
    private boolean parsed = false;
    private String mimeType = null;
    private String mediaType = null;
    private String subType = null;
    private Map<String, String> parameters = new HashMap<String, String>();
    private ParseException parseException;
    public static final FieldParser<ContentTypeField> PARSER = new FieldParser<ContentTypeField>(){

        @Override
        public ContentTypeField parse(Field rawField, DecodeMonitor monitor) {
            return new ContentTypeFieldImpl(rawField, monitor);
        }
    };

    ContentTypeFieldImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    @Override
    public String getMimeType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType;
    }

    @Override
    public String getMediaType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.subType;
    }

    @Override
    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.parameters.get(name.toLowerCase());
    }

    @Override
    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean isMimeType(String mimeType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType != null && this.mimeType.equalsIgnoreCase(mimeType);
    }

    @Override
    public boolean isMultipart() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType != null && this.mimeType.startsWith("multipart/");
    }

    @Override
    public String getBoundary() {
        return this.getParameter("boundary");
    }

    @Override
    public String getCharset() {
        return this.getParameter("charset");
    }

    public static String getMimeType(ContentTypeField child, ContentTypeField parent) {
        if (child == null || child.getMimeType() == null || child.isMultipart() && child.getBoundary() == null) {
            if (parent != null && parent.isMimeType("multipart/digest")) {
                return "message/rfc822";
            }
            return "text/plain";
        }
        return child.getMimeType();
    }

    public static String getCharset(ContentTypeField f) {
        String charset;
        if (f != null && (charset = f.getCharset()) != null && charset.length() > 0) {
            return charset;
        }
        return "us-ascii";
    }

    private void parse() {
        String body = this.getBody();
        ContentTypeParser parser = new ContentTypeParser(new StringReader(body));
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            this.parseException = e;
        }
        catch (TokenMgrError e) {
            this.parseException = new ParseException(e.getMessage());
        }
        this.mediaType = parser.getType();
        this.subType = parser.getSubType();
        if (this.mediaType != null && this.subType != null) {
            this.mimeType = (this.mediaType + "/" + this.subType).toLowerCase();
            List<String> paramNames = parser.getParamNames();
            List<String> paramValues = parser.getParamValues();
            if (paramNames != null && paramValues != null) {
                int len = Math.min(paramNames.size(), paramValues.size());
                for (int i = 0; i < len; ++i) {
                    String paramName = paramNames.get(i).toLowerCase();
                    String paramValue = paramValues.get(i);
                    this.parameters.put(paramName, paramValue);
                }
            }
        }
        this.parsed = true;
    }
}

