/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.geo.topic.GeoParserConfig;
import org.apache.tika.parser.geo.topic.GeoTag;
import org.apache.tika.parser.geo.topic.NameEntityExtractor;
import org.apache.tika.parser.geo.topic.gazetteer.GeoGazetteerClient;
import org.apache.tika.parser.geo.topic.gazetteer.Location;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeoParser
extends AbstractParser {
    private static final long serialVersionUID = -2241391757440215491L;
    private static final Logger LOG = Logger.getLogger(GeoParser.class.getName());
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"geotopic");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private GeoParserConfig config = new GeoParserConfig();
    private GeoGazetteerClient gazetteerClient;
    private boolean initialized;
    private URL modelUrl;
    private NameFinderME nameFinder;
    private boolean available;

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return SUPPORTED_TYPES;
    }

    public void initialize(URL modelUrl) {
        try {
            if (this.modelUrl != null && this.modelUrl.toURI().equals(modelUrl.toURI())) {
                return;
            }
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException(e1.getMessage());
        }
        this.modelUrl = modelUrl;
        this.gazetteerClient = new GeoGazetteerClient(this.config);
        boolean bl = this.available = modelUrl != null && this.gazetteerClient.checkAvail();
        if (this.available) {
            try {
                TokenNameFinderModel model = new TokenNameFinderModel(modelUrl);
                this.nameFinder = new NameFinderME(model);
            }
            catch (Exception e) {
                LOG.warning("Named Entity Extractor setup failed: " + e);
                this.available = false;
            }
        }
        this.initialized = true;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.config = (GeoParserConfig)context.get(GeoParserConfig.class, (Object)this.config);
        this.initialize(this.config.getNerModelUrl());
        if (!this.isAvailable()) {
            return;
        }
        NameEntityExtractor extractor = null;
        try {
            extractor = new NameEntityExtractor(this.nameFinder);
        }
        catch (Exception e) {
            LOG.warning("Named Entity Extractor setup failed: " + e);
            return;
        }
        extractor.getAllNameEntitiesfromInput(stream);
        extractor.getBestNameEntity();
        ArrayList<String> locationNameEntities = extractor.locationNameEntities;
        String bestner = extractor.bestNameEntity;
        Map<String, List<Location>> resolvedGeonames = this.searchGeoNames(locationNameEntities);
        GeoTag geotag = new GeoTag();
        geotag.toGeoTag(resolvedGeonames, bestner);
        metadata.add("Geographic_NAME", geotag.location.getName());
        metadata.add("Geographic_LONGITUDE", geotag.location.getLongitude());
        metadata.add("Geographic_LATITUDE", geotag.location.getLatitude());
        for (int i = 0; i < geotag.alternatives.size(); ++i) {
            GeoTag alter = geotag.alternatives.get(i);
            metadata.add("Optional_NAME" + (i + 1), alter.location.getName());
            metadata.add("Optional_LONGITUDE" + (i + 1), alter.location.getLongitude());
            metadata.add("Optional_LATITUDE" + (i + 1), alter.location.getLatitude());
        }
    }

    public Map<String, List<Location>> searchGeoNames(ArrayList<String> locationNameEntities) {
        return this.gazetteerClient.getLocations(locationNameEntities);
    }

    public boolean isAvailable() {
        if (!this.initialized) {
            this.initialize(this.config.getNerModelUrl());
        }
        return this.available;
    }
}

