/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.annotatedtext;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class AnnotatedTextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "annotated_text";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    private final FieldType fieldType;
    private final Builder builder;
    private final NamedAnalyzer indexAnalyzer;

    private static Builder builder(FieldMapper in) {
        return ((AnnotatedTextFieldMapper)in).builder;
    }

    private static NamedAnalyzer wrapAnalyzer(NamedAnalyzer in) {
        return new NamedAnalyzer(in.name(), AnalyzerScope.INDEX, (Analyzer)new AnnotationAnalyzerWrapper(in.analyzer()), in.getPositionIncrementGap(""));
    }

    static String readToString(Reader reader) {
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        try {
            int numCharsRead;
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            reader.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("IO Error reading field content", e);
        }
    }

    protected AnnotatedTextFieldMapper(String simpleName, FieldType fieldType, AnnotatedTextFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        assert (fieldType.tokenized());
        this.fieldType = fieldType;
        this.builder = builder;
        this.indexAnalyzer = AnnotatedTextFieldMapper.wrapAnalyzer(builder.analyzers.getIndexAnalyzer());
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.indexAnalyzer);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.mappedFieldType.name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
            if (this.fieldType.omitNorms()) {
                context.addToFieldNames(this.fieldType().name());
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.indexCreatedVersion, this.builder.analyzers.indexAnalyzers).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> (Boolean)AnnotatedTextFieldMapper.builder((FieldMapper)m).store.getValue(), (boolean)false);
        final TextParams.Analyzers analyzers;
        final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> (SimilarityProvider)AnnotatedTextFieldMapper.builder((FieldMapper)m).similarity.getValue());
        final FieldMapper.Parameter<String> indexOptions = TextParams.textIndexOptions(m -> (String)AnnotatedTextFieldMapper.builder((FieldMapper)m).indexOptions.getValue());
        final FieldMapper.Parameter<Boolean> norms = TextParams.norms((boolean)true, m -> (Boolean)AnnotatedTextFieldMapper.builder((FieldMapper)m).norms.getValue());
        final FieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> (String)AnnotatedTextFieldMapper.builder((FieldMapper)m).termVectors.getValue());
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Version indexCreatedVersion;

        public Builder(String name, Version indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> AnnotatedTextFieldMapper.builder((FieldMapper)m).analyzers.getIndexAnalyzer(), m -> (Integer)AnnotatedTextFieldMapper.builder((FieldMapper)m).analyzers.positionIncrementGap.getValue(), indexCreatedVersion);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.store, this.indexOptions, this.norms, this.termVectors, this.similarity, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.analyzers.positionIncrementGap, this.meta};
        }

        private AnnotatedTextFieldType buildFieldType(FieldType fieldType, MapperBuilderContext context) {
            TextSearchInfo tsi = new TextSearchInfo(fieldType, (SimilarityProvider)this.similarity.get(), AnnotatedTextFieldMapper.wrapAnalyzer(this.analyzers.getSearchAnalyzer()), AnnotatedTextFieldMapper.wrapAnalyzer(this.analyzers.getSearchQuoteAnalyzer()));
            return new AnnotatedTextFieldType(context.buildFullName(this.name), (Boolean)this.store.getValue(), tsi, context.isSourceSynthetic(), (Map)this.meta.getValue());
        }

        public AnnotatedTextFieldMapper build(MapperBuilderContext context) {
            FieldType fieldType = TextParams.buildFieldType(() -> true, this.store, this.indexOptions, this.norms, this.termVectors);
            if (fieldType.indexOptions() == IndexOptions.NONE) {
                throw new IllegalArgumentException("[annotated_text] fields must be indexed");
            }
            if (this.analyzers.positionIncrementGap.isConfigured() && fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
            }
            return new AnnotatedTextFieldMapper(this.name, fieldType, this.buildFieldType(fieldType, context), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this);
        }
    }

    public static final class AnnotationAnalyzerWrapper
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        public AnnotationAnalyzerWrapper(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            if (components.getTokenStream() instanceof AnnotationsInjector) {
                return components;
            }
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            return new Analyzer.TokenStreamComponents(r -> {
                AnnotatedText annotations = AnnotatedText.parse(AnnotatedTextFieldMapper.readToString(r));
                injector.setAnnotations(annotations);
                components.getSource().accept(new StringReader(annotations.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public static final class AnnotatedTextFieldType
    extends TextFieldMapper.TextFieldType {
        private AnnotatedTextFieldType(String name, boolean store, TextSearchInfo tsi, boolean isSyntheticSource, Map<String, String> meta) {
            super(name, true, store, tsi, isSyntheticSource, null, meta);
        }

        public AnnotatedTextFieldType(String name, Map<String, String> meta) {
            super(name, true, false, meta);
        }

        public String typeName() {
            return AnnotatedTextFieldMapper.CONTENT_TYPE;
        }
    }

    public static final class AnnotationsInjector
    extends TokenFilter {
        private AnnotatedText annotatedText;
        AnnotatedText.AnnotationToken nextAnnotationForInjection = null;
        private int currentAnnotationIndex = 0;
        List<AttributeSource.State> pendingStates = new ArrayList<AttributeSource.State>();
        int pendingStatePos = 0;
        boolean inputExhausted = false;
        private final OffsetAttribute textOffsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public AnnotationsInjector(TokenStream in) {
            super(in);
        }

        public void setAnnotations(AnnotatedText text) {
            this.annotatedText = text;
            this.currentAnnotationIndex = 0;
            this.nextAnnotationForInjection = text != null && text.numAnnotations() > 0 ? text.getAnnotation(0) : null;
        }

        public void reset() throws IOException {
            this.pendingStates.clear();
            this.pendingStatePos = 0;
            this.inputExhausted = false;
            super.reset();
        }

        private boolean internalNextToken() throws IOException {
            if (this.pendingStatePos < this.pendingStates.size()) {
                this.restoreState(this.pendingStates.get(this.pendingStatePos));
                ++this.pendingStatePos;
                if (this.pendingStatePos >= this.pendingStates.size()) {
                    this.pendingStatePos = 0;
                    this.pendingStates.clear();
                }
                return true;
            }
            if (this.inputExhausted) {
                return false;
            }
            return this.input.incrementToken();
        }

        public boolean incrementToken() throws IOException {
            if (this.internalNextToken()) {
                if (this.nextAnnotationForInjection != null && this.textOffsetAtt.startOffset() >= this.nextAnnotationForInjection.offset) {
                    int firstSpannedTextPosInc = this.posAtt.getPositionIncrement();
                    int annotationPosLen = 1;
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(this.captureState());
                    while (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset) {
                        if (this.input.incrementToken()) {
                            if (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset && this.textOffsetAtt.startOffset() < this.nextAnnotationForInjection.endOffset) {
                                annotationPosLen += this.posAtt.getPositionIncrement();
                            }
                            this.pendingStates.add(this.captureState());
                            continue;
                        }
                        this.inputExhausted = true;
                        break;
                    }
                    this.emitAnnotation(firstSpannedTextPosInc, annotationPosLen);
                    return true;
                }
                return true;
            }
            this.inputExhausted = true;
            return false;
        }

        private void setType() {
            this.typeAtt.setType("annotation");
        }

        private void emitAnnotation(int firstSpannedTextPosInc, int annotationPosLen) throws IOException {
            this.posLenAtt.setPositionLength(annotationPosLen);
            this.textOffsetAtt.setOffset(this.nextAnnotationForInjection.offset, this.nextAnnotationForInjection.endOffset);
            this.setType();
            int annotationOffset = this.nextAnnotationForInjection.offset;
            AnnotatedText.AnnotationToken firstAnnotationAtThisPos = this.nextAnnotationForInjection;
            while (this.nextAnnotationForInjection != null && this.nextAnnotationForInjection.offset == annotationOffset) {
                this.setType();
                this.termAtt.resizeBuffer(this.nextAnnotationForInjection.value.length());
                this.termAtt.copyBuffer(this.nextAnnotationForInjection.value.toCharArray(), 0, this.nextAnnotationForInjection.value.length());
                if (this.nextAnnotationForInjection == firstAnnotationAtThisPos) {
                    this.posAtt.setPositionIncrement(firstSpannedTextPosInc);
                    this.pendingStates.add(0, this.captureState());
                } else {
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(1, this.captureState());
                }
                ++this.currentAnnotationIndex;
                if (this.currentAnnotationIndex < this.annotatedText.numAnnotations()) {
                    this.nextAnnotationForInjection = this.annotatedText.getAnnotation(this.currentAnnotationIndex);
                    continue;
                }
                this.nextAnnotationForInjection = null;
            }
            this.internalNextToken();
        }
    }

    public static final class AnnotatedHighlighterAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private AnnotatedText[] annotations;
        int readerNum;

        public AnnotatedHighlighterAnalyzer(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        public void setAnnotations(AnnotatedText[] annotations) {
            this.annotations = annotations;
            this.readerNum = 0;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            return new Analyzer.TokenStreamComponents(r -> {
                String plainText = AnnotatedTextFieldMapper.readToString(r);
                AnnotatedText at = this.annotations[this.readerNum++];
                assert (at.textMinusMarkup.equals(plainText));
                injector.setAnnotations(at);
                components.getSource().accept(new StringReader(at.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public record AnnotatedText(String textMinusMarkup, String textPlusMarkup, List<AnnotationToken> annotations) {
        static Pattern markdownPattern = Pattern.compile("\\[([^]\\[]*)]\\(([^)(]*)\\)");

        public static AnnotatedText parse(String textPlusMarkup) {
            ArrayList<AnnotationToken> annotations = new ArrayList<AnnotationToken>();
            Matcher m = markdownPattern.matcher(textPlusMarkup);
            int lastPos = 0;
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                if (m.start() > lastPos) {
                    sb.append(textPlusMarkup, lastPos, m.start());
                }
                int startOffset = sb.length();
                int endOffset = sb.length() + m.group(1).length();
                sb.append(m.group(1));
                lastPos = m.end();
                String[] pairs = m.group(2).split("&");
                String value = null;
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    if (kv.length == 2) {
                        throw new ElasticsearchParseException("key=value pairs are not supported in annotations", new Object[0]);
                    }
                    if (kv.length == 1 && kv[0].length() == pair.length()) {
                        value = URLDecoder.decode(kv[0], StandardCharsets.UTF_8);
                    }
                    if (value == null || value.length() <= 0) continue;
                    annotations.add(new AnnotationToken(startOffset, endOffset, value));
                }
            }
            if (lastPos < textPlusMarkup.length()) {
                sb.append(textPlusMarkup.substring(lastPos));
            }
            return new AnnotatedText(sb.toString(), textPlusMarkup, annotations);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.textMinusMarkup);
            sb.append("\n");
            this.annotations.forEach(a -> {
                sb.append(a);
                sb.append("\n");
            });
            return sb.toString();
        }

        public int numAnnotations() {
            return this.annotations.size();
        }

        public AnnotationToken getAnnotation(int index) {
            return this.annotations.get(index);
        }

        public record AnnotationToken(int offset, int endOffset, String value) {
            @Override
            public String toString() {
                return this.value + " (" + this.offset + " - " + this.endOffset + ")";
            }

            public boolean intersects(int start, int end) {
                return start <= this.offset && end >= this.offset || start <= this.endOffset && end >= this.endOffset || start >= this.offset && end <= this.endOffset;
            }
        }
    }
}

