/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.annotatedtext.AnnotatedTextFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.AnnotatedPassageFormatter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;

public class AnnotatedTextHighlighter
extends UnifiedHighlighter {
    public static final String NAME = "annotated";

    protected Analyzer getAnalyzer(DocumentMapper docMapper, FetchSubPhase.HitContext hitContext) {
        return new AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer(super.getAnalyzer(docMapper, hitContext), hitContext);
    }

    protected List<Object> loadFieldValues(MappedFieldType fieldType, SearchContextHighlight.Field field, QueryShardContext context, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List fieldValues = super.loadFieldValues(fieldType, field, context, hitContext, forceSource);
        String[] fieldValuesAsString = fieldValues.toArray(new String[fieldValues.size()]);
        AnnotatedTextFieldMapper.AnnotatedText[] annotations = new AnnotatedTextFieldMapper.AnnotatedText[fieldValuesAsString.length];
        for (int i = 0; i < fieldValuesAsString.length; ++i) {
            annotations[i] = AnnotatedTextFieldMapper.AnnotatedText.parse(fieldValuesAsString[i]);
        }
        hitContext.cache().put(AnnotatedTextFieldMapper.AnnotatedText.class.getName(), annotations);
        ArrayList<Object> result = new ArrayList<Object>(annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result.add(annotations[i].textMinusMarkup);
        }
        return result;
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchContextHighlight.Field field, Encoder encoder) {
        AnnotatedTextFieldMapper.AnnotatedText[] annotations = (AnnotatedTextFieldMapper.AnnotatedText[])hitContext.cache().get(AnnotatedTextFieldMapper.AnnotatedText.class.getName());
        return new AnnotatedPassageFormatter(annotations, encoder);
    }
}

