/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.annotatedtext;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.fetch.FetchSubPhase;

public class AnnotatedTextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "annotated_text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    private int positionIncrementGap;

    static String readToString(Reader reader) {
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        try {
            int numCharsRead;
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            reader.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("IO Error reading field content", e);
        }
    }

    protected AnnotatedTextFieldMapper(String simpleName, AnnotatedTextFieldType fieldType, MappedFieldType defaultFieldType, int positionIncrementGap, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, (MappedFieldType)fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.tokenized());
        assert (!fieldType.hasDocValues());
        this.positionIncrementGap = positionIncrementGap;
    }

    protected AnnotatedTextFieldMapper clone() {
        return (AnnotatedTextFieldMapper)super.clone();
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType());
            fields.add((IndexableField)field);
            if (this.fieldType().omitNorms()) {
                this.createFieldNamesField(context, fields);
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public AnnotatedTextFieldType fieldType() {
        return (AnnotatedTextFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (includeDefaults || this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
    }

    public static final class AnnotatedTextFieldType
    extends StringFieldType {
        public AnnotatedTextFieldType() {
            this.setTokenized(true);
        }

        protected AnnotatedTextFieldType(AnnotatedTextFieldType ref) {
            super((MappedFieldType)ref);
        }

        public void setIndexAnalyzer(NamedAnalyzer delegate) {
            if (delegate.analyzer() instanceof AnnotationAnalyzerWrapper) {
                super.setIndexAnalyzer(delegate);
            } else {
                super.setIndexAnalyzer(new NamedAnalyzer(delegate.name(), AnalyzerScope.INDEX, (Analyzer)new AnnotationAnalyzerWrapper(delegate.analyzer())));
            }
        }

        public AnnotatedTextFieldType clone() {
            return new AnnotatedTextFieldType(this);
        }

        public String typeName() {
            return AnnotatedTextFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery((TokenStream)stream, (String)this.name(), (int)slop, (boolean)enablePositionIncrements);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            return TextFieldMapper.createPhrasePrefixQuery((TokenStream)stream, (String)this.name(), (int)slop, (int)maxExpansions, null, null);
        }
    }

    public static final class AnnotationsInjector
    extends TokenFilter {
        private AnnotatedText annotatedText;
        AnnotatedText.AnnotationToken nextAnnotationForInjection = null;
        private int currentAnnotationIndex = 0;
        List<AttributeSource.State> pendingStates = new ArrayList<AttributeSource.State>();
        int pendingStatePos = 0;
        boolean inputExhausted = false;
        private final OffsetAttribute textOffsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public AnnotationsInjector(TokenStream in) {
            super(in);
        }

        public void setAnnotations(AnnotatedText annotatedText) {
            this.annotatedText = annotatedText;
            this.currentAnnotationIndex = 0;
            this.nextAnnotationForInjection = annotatedText != null && annotatedText.numAnnotations() > 0 ? annotatedText.getAnnotation(0) : null;
        }

        public void reset() throws IOException {
            this.pendingStates.clear();
            this.pendingStatePos = 0;
            this.inputExhausted = false;
            super.reset();
        }

        private boolean internalNextToken() throws IOException {
            if (this.pendingStatePos < this.pendingStates.size()) {
                this.restoreState(this.pendingStates.get(this.pendingStatePos));
                ++this.pendingStatePos;
                if (this.pendingStatePos >= this.pendingStates.size()) {
                    this.pendingStatePos = 0;
                    this.pendingStates.clear();
                }
                return true;
            }
            if (this.inputExhausted) {
                return false;
            }
            return this.input.incrementToken();
        }

        public boolean incrementToken() throws IOException {
            if (this.internalNextToken()) {
                if (this.nextAnnotationForInjection != null && this.textOffsetAtt.startOffset() >= this.nextAnnotationForInjection.offset) {
                    int firstSpannedTextPosInc = this.posAtt.getPositionIncrement();
                    int annotationPosLen = 1;
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(this.captureState());
                    while (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset) {
                        if (this.input.incrementToken()) {
                            if (this.textOffsetAtt.endOffset() <= this.nextAnnotationForInjection.endOffset && this.textOffsetAtt.startOffset() < this.nextAnnotationForInjection.endOffset) {
                                annotationPosLen += this.posAtt.getPositionIncrement();
                            }
                            this.pendingStates.add(this.captureState());
                            continue;
                        }
                        this.inputExhausted = true;
                        break;
                    }
                    this.emitAnnotation(firstSpannedTextPosInc, annotationPosLen);
                    return true;
                }
                return true;
            }
            this.inputExhausted = true;
            return false;
        }

        private void setType(AnnotatedText.AnnotationToken token) {
            this.typeAtt.setType("annotation");
        }

        private void emitAnnotation(int firstSpannedTextPosInc, int annotationPosLen) throws IOException {
            this.posLenAtt.setPositionLength(annotationPosLen);
            this.textOffsetAtt.setOffset(this.nextAnnotationForInjection.offset, this.nextAnnotationForInjection.endOffset);
            this.setType(this.nextAnnotationForInjection);
            int annotationOffset = this.nextAnnotationForInjection.offset;
            AnnotatedText.AnnotationToken firstAnnotationAtThisPos = this.nextAnnotationForInjection;
            while (this.nextAnnotationForInjection != null && this.nextAnnotationForInjection.offset == annotationOffset) {
                this.setType(this.nextAnnotationForInjection);
                this.termAtt.resizeBuffer(this.nextAnnotationForInjection.value.length());
                this.termAtt.copyBuffer(this.nextAnnotationForInjection.value.toCharArray(), 0, this.nextAnnotationForInjection.value.length());
                if (this.nextAnnotationForInjection == firstAnnotationAtThisPos) {
                    this.posAtt.setPositionIncrement(firstSpannedTextPosInc);
                    this.pendingStates.add(0, this.captureState());
                } else {
                    this.posAtt.setPositionIncrement(0);
                    this.pendingStates.add(1, this.captureState());
                }
                ++this.currentAnnotationIndex;
                if (this.currentAnnotationIndex < this.annotatedText.numAnnotations()) {
                    this.nextAnnotationForInjection = this.annotatedText.getAnnotation(this.currentAnnotationIndex);
                    continue;
                }
                this.nextAnnotationForInjection = null;
            }
            this.internalNextToken();
        }
    }

    public static final class AnnotationAnalyzerWrapper
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        public AnnotationAnalyzerWrapper(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            if (components.getTokenStream() instanceof AnnotationsInjector) {
                return components;
            }
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            return new Analyzer.TokenStreamComponents(r -> {
                AnnotatedText annotations = AnnotatedText.parse(AnnotatedTextFieldMapper.readToString(r));
                injector.setAnnotations(annotations);
                components.getSource().accept(new StringReader(annotations.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public static final class AnnotatedHighlighterAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final FetchSubPhase.HitContext hitContext;

        public AnnotatedHighlighterAnalyzer(Analyzer delegate, FetchSubPhase.HitContext hitContext) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.hitContext = hitContext;
        }

        public Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            AnnotationsInjector injector = new AnnotationsInjector(components.getTokenStream());
            AnnotatedText[] annotations = (AnnotatedText[])this.hitContext.cache().get(AnnotatedText.class.getName());
            AtomicInteger readerNum = new AtomicInteger(0);
            return new Analyzer.TokenStreamComponents(r -> {
                String plainText = AnnotatedTextFieldMapper.readToString(r);
                AnnotatedText at = annotations[readerNum.getAndIncrement()];
                assert (at.textMinusMarkup.equals(plainText));
                injector.setAnnotations(at);
                components.getSource().accept(new StringReader(at.textMinusMarkup));
            }, (TokenStream)injector);
        }
    }

    public static final class AnnotatedText {
        public final String textPlusMarkup;
        public final String textMinusMarkup;
        List<AnnotationToken> annotations;
        static Pattern markdownPattern = Pattern.compile("\\[([^\\]\\[]*)\\]\\(([^\\)\\(]*)\\)");

        public static AnnotatedText parse(String textPlusMarkup) {
            ArrayList<AnnotationToken> annotations = new ArrayList<AnnotationToken>();
            Matcher m = markdownPattern.matcher(textPlusMarkup);
            int lastPos = 0;
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                if (m.start() > lastPos) {
                    sb.append(textPlusMarkup.substring(lastPos, m.start()));
                }
                int startOffset = sb.length();
                int endOffset = sb.length() + m.group(1).length();
                sb.append(m.group(1));
                lastPos = m.end();
                String[] pairs = m.group(2).split("&");
                String value = null;
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    try {
                        if (kv.length == 2) {
                            throw new ElasticsearchParseException("key=value pairs are not supported in annotations", new Object[0]);
                        }
                        if (kv.length == 1 && kv[0].length() == pair.length()) {
                            value = URLDecoder.decode(kv[0], "UTF-8");
                        }
                        if (value == null || value.length() <= 0) continue;
                        annotations.add(new AnnotationToken(startOffset, endOffset, value));
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new ElasticsearchParseException("Unsupported encoding parsing annotated text", (Throwable)uee, new Object[0]);
                    }
                }
            }
            if (lastPos < textPlusMarkup.length()) {
                sb.append(textPlusMarkup.substring(lastPos));
            }
            return new AnnotatedText(sb.toString(), textPlusMarkup, annotations);
        }

        protected AnnotatedText(String textMinusMarkup, String textPlusMarkup, List<AnnotationToken> annotations) {
            this.textMinusMarkup = textMinusMarkup;
            this.textPlusMarkup = textPlusMarkup;
            this.annotations = annotations;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.textMinusMarkup);
            sb.append("\n");
            this.annotations.forEach(a -> {
                sb.append(a);
                sb.append("\n");
            });
            return sb.toString();
        }

        public int numAnnotations() {
            return this.annotations.size();
        }

        public AnnotationToken getAnnotation(int index) {
            return this.annotations.get(index);
        }

        public static final class AnnotationToken {
            public final int offset;
            public final int endOffset;
            public final String value;

            public AnnotationToken(int offset, int endOffset, String value) {
                this.offset = offset;
                this.endOffset = endOffset;
                this.value = value;
            }

            public String toString() {
                return this.value + " (" + this.offset + " - " + this.endOffset + ")";
            }

            public boolean intersects(int start, int end) {
                return start <= this.offset && end >= this.offset || start <= this.endOffset && end >= this.endOffset || start >= this.offset && end <= this.endOffset;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.endOffset;
                result = 31 * result + this.offset;
                result = 31 * result + Objects.hashCode(this.value);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AnnotationToken other = (AnnotationToken)obj;
                return Objects.equals(this.endOffset, other.endOffset) && Objects.equals(this.offset, other.offset) && Objects.equals(this.value, other.value);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<Builder, AnnotatedTextFieldMapper> parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(fieldName);
            builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            TypeParsers.parseTextField((FieldMapper.Builder)builder, (String)fieldName, node, (Mapper.TypeParser.ParserContext)parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("position_increment_gap")) continue;
                int newPositionIncrementGap = XContentMapValues.nodeIntegerValue((Object)propNode, (int)-1);
                builder.positionIncrementGap(newPositionIncrementGap);
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, AnnotatedTextFieldMapper> {
        private int positionIncrementGap = -1;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public AnnotatedTextFieldType fieldType() {
            return (AnnotatedTextFieldType)super.fieldType();
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            if (positionIncrementGap < 0) {
                throw new MapperParsingException("[positions_increment_gap] must be positive, got " + positionIncrementGap);
            }
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("[annotated_text] fields do not support doc values");
            }
            return (Builder)super.docValues(docValues);
        }

        public AnnotatedTextFieldMapper build(Mapper.BuilderContext context) {
            if (this.fieldType().indexOptions() == IndexOptions.NONE) {
                throw new IllegalArgumentException("[annotated_text] fields must be indexed");
            }
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), this.positionIncrementGap));
            } else if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
                int overrideInc = 100;
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), overrideInc));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), overrideInc));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), overrideInc));
            }
            this.setupFieldType(context);
            return new AnnotatedTextFieldMapper(this.name, this.fieldType(), this.defaultFieldType, this.positionIncrementGap, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new AnnotatedTextFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

