/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.annotatedtext.AnnotatedTextFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.AnnotatedPassageFormatter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;

public class AnnotatedTextHighlighter
extends UnifiedHighlighter {
    public static final String NAME = "annotated";

    protected List<Object> loadFieldValues(CustomUnifiedHighlighter highlighter, SearchExecutionContext searchContext, MappedFieldType fieldType, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List fieldValues = super.loadFieldValues(highlighter, searchContext, fieldType, hitContext, forceSource);
        ArrayList<Object> strings = new ArrayList<Object>(fieldValues.size());
        AnnotatedTextFieldMapper.AnnotatedText[] annotations = new AnnotatedTextFieldMapper.AnnotatedText[fieldValues.size()];
        for (int i = 0; i < fieldValues.size(); ++i) {
            annotations[i] = AnnotatedTextFieldMapper.AnnotatedText.parse(fieldValues.get(i).toString());
            strings.add(annotations[i].textMinusMarkup);
        }
        ((AnnotatedPassageFormatter)highlighter.getFormatter()).setAnnotations(annotations);
        ((AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer)highlighter.getIndexAnalyzer()).setAnnotations(annotations);
        return strings;
    }

    protected Analyzer wrapAnalyzer(Analyzer analyzer, Integer maxAnalyzedOffset) {
        return new AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer(super.wrapAnalyzer(analyzer, maxAnalyzedOffset));
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchHighlightContext.Field field, Encoder encoder) {
        return new AnnotatedPassageFormatter(encoder);
    }
}

