/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.annotatedtext.AnnotatedTextFieldMapper;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.AnnotatedPassageFormatter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.elasticsearch.search.internal.SearchContext;

public class AnnotatedTextHighlighter
extends UnifiedHighlighter {
    public static final String NAME = "annotated";
    AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer annotatedHighlighterAnalyzer = null;

    protected Analyzer getAnalyzer(DocumentMapper docMapper, MappedFieldType type) {
        this.annotatedHighlighterAnalyzer = new AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer(super.getAnalyzer(docMapper, type));
        return this.annotatedHighlighterAnalyzer;
    }

    protected List<Object> loadFieldValues(MappedFieldType fieldType, SearchContextHighlight.Field field, SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
        List fieldValues = super.loadFieldValues(fieldType, field, context, hitContext);
        String[] fieldValuesAsString = fieldValues.toArray(new String[fieldValues.size()]);
        this.annotatedHighlighterAnalyzer.init(fieldValuesAsString);
        return Arrays.asList((Object[])this.annotatedHighlighterAnalyzer.getPlainTextValuesForHighlighter());
    }

    protected PassageFormatter getPassageFormatter(SearchContextHighlight.Field field, Encoder encoder) {
        return new AnnotatedPassageFormatter(this.annotatedHighlighterAnalyzer, encoder);
    }
}

