/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.python;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;

public class PythonScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "python";
    public static final String EXTENSION = "py";
    private final PythonInterpreter interp;
    private static final AccessControlContext PY_CONTEXT;

    public PythonScriptEngineService(Settings settings) {
        super(settings);
        this.deprecationLogger.deprecated("[python] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        this.interp = AccessController.doPrivileged(new PrivilegedAction<PythonInterpreter>(){

            @Override
            public PythonInterpreter run() {
                final AccessControlContext engineContext = AccessController.getContext();
                PythonInterpreter interp = PythonInterpreter.threadLocalStateInterpreter(null);
                if (sm != null) {
                    interp.getSystemState().setClassLoader(new ClassLoader(this.getClass().getClassLoader()){

                        @Override
                        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                            try {
                                engineContext.checkPermission((Permission)new ClassPermission(name));
                            }
                            catch (SecurityException e) {
                                throw new ClassNotFoundException(name, e);
                            }
                            return super.loadClass(name, resolve);
                        }
                    });
                }
                return interp;
            }
        });
    }

    public String getType() {
        return NAME;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public Object compile(String scriptName, final String scriptSource, Map<String, String> params) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<PyCode>(){

            @Override
            public PyCode run() {
                return PythonScriptEngineService.this.interp.compile(scriptSource);
            }
        });
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        this.deprecationLogger.deprecated("[python] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        return new PythonExecutableScript((PyCode)compiledScript.compiled(), vars);
    }

    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        this.deprecationLogger.deprecated("[python] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        return new SearchScript(){

            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                return new PythonSearchScript((PyCode)compiledScript.compiled(), vars, leafLookup);
            }

            public boolean needsScores() {
                return true;
            }
        };
    }

    public void close() {
        this.interp.cleanup();
    }

    private PyObject evalRestricted(final PyCode code) {
        return AccessController.doPrivileged(new PrivilegedAction<PyObject>(){

            @Override
            public PyObject run() {
                return PythonScriptEngineService.this.interp.eval((PyObject)code);
            }
        }, PY_CONTEXT);
    }

    public static Object unwrapValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PyObject) {
            return ((PyObject)value).__tojava__(Object.class);
        }
        return value;
    }

    static {
        Permissions none = new Permissions();
        none.setReadOnly();
        PY_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, none)});
    }

    public class PythonSearchScript
    implements LeafSearchScript {
        private final PyCode code;
        private final PyStringMap pyVars;
        private final LeafSearchLookup lookup;

        public PythonSearchScript(PyCode code, Map<String, Object> vars, LeafSearchLookup lookup) {
            this.code = code;
            this.pyVars = new PyStringMap();
            for (Map.Entry entry : lookup.asMap().entrySet()) {
                this.pyVars.__setitem__((String)entry.getKey(), Py.java2py(entry.getValue()));
            }
            if (vars != null) {
                for (Map.Entry<Object, Object> entry : vars.entrySet()) {
                    this.pyVars.__setitem__((String)entry.getKey(), Py.java2py((Object)entry.getValue()));
                }
            }
            this.lookup = lookup;
        }

        public void setScorer(Scorer scorer) {
            this.pyVars.__setitem__("_score", Py.java2py((Object)new ScoreAccessor(scorer)));
        }

        public void setDocument(int doc) {
            this.lookup.setDocument(doc);
        }

        public void setSource(Map<String, Object> source) {
            this.lookup.source().setSource(source);
        }

        public void setNextVar(String name, Object value) {
            this.pyVars.__setitem__(name, Py.java2py((Object)value));
        }

        public Object run() {
            PythonScriptEngineService.this.interp.setLocals((PyObject)this.pyVars);
            PyObject ret = PythonScriptEngineService.this.evalRestricted(this.code);
            if (ret == null) {
                return null;
            }
            return ret.__tojava__(Object.class);
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        public Object unwrap(Object value) {
            return PythonScriptEngineService.unwrapValue(value);
        }
    }

    public class PythonExecutableScript
    implements ExecutableScript {
        private final PyCode code;
        private final PyStringMap pyVars;

        public PythonExecutableScript(PyCode code, Map<String, Object> vars) {
            this.code = code;
            this.pyVars = new PyStringMap();
            if (vars != null) {
                for (Map.Entry<String, Object> entry : vars.entrySet()) {
                    this.pyVars.__setitem__(entry.getKey(), Py.java2py((Object)entry.getValue()));
                }
            }
        }

        public void setNextVar(String name, Object value) {
            this.pyVars.__setitem__(name, Py.java2py((Object)value));
        }

        public Object run() {
            PythonScriptEngineService.this.interp.setLocals((PyObject)this.pyVars);
            PyObject ret = PythonScriptEngineService.this.evalRestricted(this.code);
            if (ret == null) {
                return null;
            }
            return ret.__tojava__(Object.class);
        }

        public Object unwrap(Object value) {
            return PythonScriptEngineService.unwrapValue(value);
        }
    }
}

