/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.xml.AbstractXML2003Parser;
import org.apache.tika.parser.microsoft.xml.HyperlinkHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class WordMLParser
extends AbstractXML2003Parser {
    private static final Map<String, String> WORDML_TO_XHTML;
    private static final Set<QName> IGNORE_CHARACTERS;
    private static final MediaType MEDIA_TYPE;
    private static final Set<MediaType> SUPPORTED_TYPES;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    protected ContentHandler getContentHandler(ContentHandler ch, Metadata metadata, ParseContext context) {
        return new TeeContentHandler(new ContentHandler[]{super.getContentHandler(ch, metadata, context), new WordMLHandler(ch), new HyperlinkHandler(ch, "http://schemas.microsoft.com/office/word/2003/wordml"), new PictHandler(ch, EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context))});
    }

    @Override
    public void setContentType(Metadata metadata) {
        metadata.set("Content-Type", MEDIA_TYPE.toString());
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("p", "p");
        m.put("tbl", "table");
        m.put("tr", "tr");
        m.put("tc", "td");
        WORDML_TO_XHTML = Collections.unmodifiableMap(m);
        IGNORE_CHARACTERS = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(new QName("http://schemas.microsoft.com/office/word/2003/wordml", "hlink"), new QName("http://schemas.microsoft.com/office/word/2003/wordml", "pict"), new QName("http://schemas.microsoft.com/office/word/2003/wordml", "binData"), new QName("urn:schemas-microsoft-com:office:office", "DocumentProperties"))));
        MEDIA_TYPE = MediaType.application((String)"vnd.ms-wordml");
        SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    }

    private class PictHandler
    extends DefaultHandler {
        final StringBuilder buffer = new StringBuilder();
        final ContentHandler handler;
        byte[] rawBytes = null;
        EmbeddedDocumentExtractor embeddedDocumentExtractor;
        boolean inPict = false;
        boolean inBin = false;
        String pictName = null;
        String pictSource = null;
        final Base64 base64 = new Base64();

        public PictHandler(ContentHandler handler, EmbeddedDocumentExtractor embeddedDocumentExtractor) {
            this.handler = handler;
            this.embeddedDocumentExtractor = embeddedDocumentExtractor;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if ("http://schemas.microsoft.com/office/word/2003/wordml".equals(uri)) {
                if ("pict".equals(localName)) {
                    this.inPict = true;
                } else if ("binData".equals(localName)) {
                    this.inBin = true;
                    this.pictName = attrs.getValue("http://schemas.microsoft.com/office/word/2003/wordml", "name");
                    if (this.pictName != null) {
                        this.pictName = this.pictName.replaceFirst("wordml://", "");
                    }
                }
            } else if ("urn:schemas-microsoft-com:vml".equals(uri) && localName.equals("imagedata")) {
                String src = attrs.getValue("", "src");
                String title = attrs.getValue("urn:schemas-microsoft-com:office:office", "title");
                if (title != null && !title.equals("")) {
                    int i;
                    if (src != null && (i = src.lastIndexOf(".")) > -1 && i + 1 < src.length()) {
                        String ext = src.substring(i);
                        title = title + ext;
                    }
                    this.pictSource = title;
                }
            }
        }

        @Override
        public void characters(char[] str, int offset, int len) throws SAXException {
            if (this.inBin) {
                this.buffer.append(str, offset, len);
            } else if (this.inPict) {
                this.handler.characters(str, offset, len);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!"http://schemas.microsoft.com/office/word/2003/wordml".equals(uri)) {
                return;
            }
            if ("pict".equals(localName)) {
                this.inPict = false;
                AttributesImpl attrs = new AttributesImpl();
                if (this.pictName != null) {
                    attrs.addAttribute("http://www.w3.org/1999/xhtml", "href", "href", "cdata", this.pictName);
                }
                this.handler.startElement("http://www.w3.org/1999/xhtml", "img", "img", attrs);
                this.handler.endElement("http://www.w3.org/1999/xhtml", "img", "img");
                this.handleEmbedded();
            } else if ("binData".equals(localName)) {
                this.inBin = false;
                this.rawBytes = this.base64.decode(this.buffer.toString());
                this.buffer.setLength(0);
                if (!this.inPict) {
                    this.handleEmbedded();
                }
            }
        }

        private void handleEmbedded() throws SAXException {
            if (this.rawBytes != null) {
                try (TikaInputStream is = TikaInputStream.get((byte[])this.rawBytes);){
                    Metadata metadata = new Metadata();
                    if (this.pictName != null) {
                        metadata.set("resourceName", this.pictName);
                    }
                    if (this.pictSource != null) {
                        metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, this.pictSource);
                    }
                    if (this.embeddedDocumentExtractor.shouldParseEmbedded(metadata)) {
                        this.embeddedDocumentExtractor.parseEmbedded((InputStream)is, this.handler, metadata, false);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.pictName = null;
            this.pictSource = null;
            this.rawBytes = null;
        }
    }

    private class WordMLHandler
    extends DefaultHandler {
        private final ContentHandler handler;
        private boolean ignoreCharacters;
        private boolean inBody = false;
        private boolean inP;

        public WordMLHandler(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            localName = localName.toLowerCase(Locale.US);
            if ("http://schemas.microsoft.com/office/word/2003/wordml".equals(uri)) {
                if ("body".equals(localName)) {
                    this.inBody = true;
                    return;
                }
                String html = (String)WORDML_TO_XHTML.get(localName);
                if (html != null) {
                    if ("p".equals(localName)) {
                        if (this.inP) {
                            this.handler.endElement("http://www.w3.org/1999/xhtml", "p", "p");
                        }
                        this.inP = true;
                    }
                    this.handler.startElement("http://www.w3.org/1999/xhtml", html, html, AbstractXML2003Parser.EMPTY_ATTRS);
                    if (html.equals("table")) {
                        this.handler.startElement("http://www.w3.org/1999/xhtml", "tbody", "tbody", AbstractXML2003Parser.EMPTY_ATTRS);
                    }
                }
                if ("br".equals(localName)) {
                    this.handler.characters(AbstractXML2003Parser.NEWLINE, 0, 1);
                }
            }
            if (IGNORE_CHARACTERS.contains(new QName(uri, localName))) {
                this.ignoreCharacters = true;
            }
        }

        @Override
        public void characters(char[] str, int offset, int len) throws SAXException {
            if (!this.ignoreCharacters && this.inBody) {
                this.handler.characters(str, offset, len);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("http://schemas.microsoft.com/office/word/2003/wordml".equals(uri)) {
                localName = localName.toLowerCase(Locale.US);
                String html = (String)WORDML_TO_XHTML.get(localName);
                if (html != null) {
                    if (html.equals("table")) {
                        this.handler.endElement("http://www.w3.org/1999/xhtml", "tbody", "tbody");
                    }
                    if ("p".equals(html) && !this.inP) {
                        this.handler.startElement("http://www.w3.org/1999/xhtml", "p", "p", AbstractXML2003Parser.EMPTY_ATTRS);
                    }
                    this.handler.endElement("http://www.w3.org/1999/xhtml", html, html);
                    if ("p".equals(html)) {
                        this.inP = false;
                    }
                }
            }
            if (IGNORE_CHARACTERS.contains(new QName(uri, localName))) {
                this.ignoreCharacters = false;
            }
        }
    }
}

