/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.EndianUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.parser.microsoft.onenote.CheckedFileNodePushBack;
import org.apache.tika.parser.microsoft.onenote.CompactID;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileChunkReference;
import org.apache.tika.parser.microsoft.onenote.FileDataStoreObject;
import org.apache.tika.parser.microsoft.onenote.FileNode;
import org.apache.tika.parser.microsoft.onenote.FileNodeList;
import org.apache.tika.parser.microsoft.onenote.FileNodeListHeader;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.FileNodePtrBackPush;
import org.apache.tika.parser.microsoft.onenote.FndStructureConstants;
import org.apache.tika.parser.microsoft.onenote.GUID;
import org.apache.tika.parser.microsoft.onenote.Int24;
import org.apache.tika.parser.microsoft.onenote.ObjectDeclarationWithRefCountBody;
import org.apache.tika.parser.microsoft.onenote.ObjectInfoDependencyOverrideData;
import org.apache.tika.parser.microsoft.onenote.ObjectSpaceObjectPropSet;
import org.apache.tika.parser.microsoft.onenote.ObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs;
import org.apache.tika.parser.microsoft.onenote.ObjectStreamCounters;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNoteHeader;
import org.apache.tika.parser.microsoft.onenote.OneNoteParser;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyId;
import org.apache.tika.parser.microsoft.onenote.PropertySet;
import org.apache.tika.parser.microsoft.onenote.PropertyValue;
import org.apache.tika.parser.microsoft.onenote.Revision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OneNotePtr {
    private static final Logger LOG = LoggerFactory.getLogger(OneNoteParser.class);
    public static final long FOOTER_CONST = -8376108427508467125L;
    public static final String UNKNOWN = "unknown";
    private static final byte[] IFNDF = new byte[]{60, 0, 105, 0, 102, 0, 110, 0, 100, 0, 102, 0, 62, 0};
    private static final GUID FILE_DATA_STORE_OBJ_HEADER = new GUID(new int[]{189, 227, 22, 231, 38, 101, 69, 17, 164, 196, 141, 77, 11, 122, 158, 172});
    private static final GUID FILE_DATA_STORE_OBJ_FOOTER = new GUID(new int[]{113, 251, 167, 34, 15, 121, 74, 11, 187, 19, 137, 146, 86, 66, 107, 36});
    public static final int IFNDF_GUID_LENGTH = 38;
    public static final int NUM_RESERVED_BYTES_AT_END_OF_HEADER = 728;
    int indentLevel = 0;
    long offset;
    long end;
    OneNoteDocument document;
    OneNoteDirectFileResource dif;

    public OneNotePtr(OneNoteDocument document, OneNoteDirectFileResource oneNoteDirectFileResource) throws IOException {
        this.document = document;
        this.dif = oneNoteDirectFileResource;
        this.offset = oneNoteDirectFileResource.position();
        this.end = oneNoteDirectFileResource.size();
    }

    public OneNotePtr(OneNotePtr oneNotePtr) {
        this.document = oneNotePtr.document;
        this.dif = oneNotePtr.dif;
        this.offset = oneNotePtr.offset;
        this.end = oneNotePtr.end;
        this.indentLevel = oneNotePtr.indentLevel;
    }

    public OneNoteHeader deserializeHeader() throws IOException, TikaException {
        OneNoteHeader data = new OneNoteHeader();
        data.setGuidFileType(this.deserializeGUID()).setGuidFile(this.deserializeGUID()).setGuidLegacyFileVersion(this.deserializeGUID()).setGuidFileFormat(this.deserializeGUID()).setFfvLastCodeThatWroteToThisFile(this.deserializeLittleEndianInt()).setFfvOldestCodeThatHasWrittenToThisFile(this.deserializeLittleEndianInt()).setFfvNewestCodeThatHasWrittenToThisFile(this.deserializeLittleEndianInt()).setFfvOldestCodeThatMayReadThisFile(this.deserializeLittleEndianInt()).setFcrLegacyFreeChunkList(this.deserializeFileChunkReference64()).setFcrLegacyTransactionLog(this.deserializeFileChunkReference64()).setcTransactionsInLog(this.deserializeLittleEndianInt()).setCbExpectedFileLength(this.deserializeLittleEndianInt()).setRgbPlaceholder(this.deserializeLittleEndianLong()).setFcrLegacyFileNodeListRoot(this.deserializeFileChunkReference64()).setCbLegacyFreeSpaceInFreeChunkList(this.deserializeLittleEndianInt()).setIgnoredZeroA(this.deserializeLittleEndianChar()).setIgnoredZeroB(this.deserializeLittleEndianChar()).setIgnoredZeroC(this.deserializeLittleEndianChar()).setIgnoredZeroD(this.deserializeLittleEndianChar()).setGuidAncestor(this.deserializeGUID()).setCrcName(this.deserializeLittleEndianInt()).setFcrHashedChunkList(this.deserializeFileChunkReference64x32()).setFcrTransactionLog(this.deserializeFileChunkReference64x32()).setFcrFileNodeListRoot(this.deserializeFileChunkReference64x32()).setFcrFreeChunkList(this.deserializeFileChunkReference64x32()).setCbExpectedFileLength(this.deserializeLittleEndianLong()).setCbFreeSpaceInFreeChunkList(this.deserializeLittleEndianLong()).setGuidFileVersion(this.deserializeGUID()).setnFileVersionGeneration(this.deserializeLittleEndianLong()).setGuidDenyReadFileVersion(this.deserializeGUID()).setGrfDebugLogFlags(this.deserializeLittleEndianInt()).setFcrDebugLogA(this.deserializeFileChunkReference64x32()).setFcrDebugLogB(this.deserializeFileChunkReference64x32()).setBuildNumberCreated(this.deserializeLittleEndianInt()).setBuildNumberLastWroteToFile(this.deserializeLittleEndianInt()).setBuildNumberOldestWritten(this.deserializeLittleEndianInt()).setBuildNumberNewestWritten(this.deserializeLittleEndianInt());
        ByteBuffer reservedBytesAtEndOfHeader = ByteBuffer.allocate(728);
        this.deserializeBytes(reservedBytesAtEndOfHeader);
        return data;
    }

    private GUID deserializeGUID() throws IOException {
        int[] guid = new int[16];
        for (int i = 0; i < 16; ++i) {
            guid[i] = this.dif.read();
        }
        int[] guid2 = new int[]{guid[3], guid[2], guid[1], guid[0], guid[5], guid[4], guid[7], guid[6], guid[8], guid[9], guid[10], guid[11], guid[12], guid[13], guid[14], guid[15]};
        this.offset = this.dif.position();
        return new GUID(guid2);
    }

    private byte[] deserializedReservedHeader() throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        ByteBuffer data = ByteBuffer.allocate(728);
        this.dif.read(data);
        this.offset = this.dif.position();
        return data.array();
    }

    private FileChunkReference deserializeFileChunkReference64() throws IOException {
        long stp = this.deserializeLittleEndianInt();
        long cb = this.deserializeLittleEndianInt();
        this.offset = this.dif.position();
        return new FileChunkReference(stp, cb);
    }

    private FileChunkReference deserializeFileChunkReference64x32() throws IOException {
        long stp = this.deserializeLittleEndianLong();
        long cb = this.deserializeLittleEndianInt();
        this.offset = this.dif.position();
        return new FileChunkReference(stp, cb);
    }

    private char deserializeLittleEndianChar() throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        char res = (char)this.dif.read();
        ++this.offset;
        return res;
    }

    private long deserializeLittleEndianInt() throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.dif.read(byteBuffer);
        long res = EndianUtils.readSwappedUnsignedInteger((byte[])byteBuffer.array(), (int)0);
        this.offset = this.dif.position();
        return res;
    }

    private long deserializeLittleEndianLong() throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        this.dif.read(byteBuffer);
        long res = EndianUtils.readSwappedLong((byte[])byteBuffer.array(), (int)0);
        this.offset = this.dif.position();
        return res;
    }

    private long deserializeLittleEndianShort() throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        int c1 = this.dif.read();
        int c2 = this.dif.read();
        long res = ((c1 & 0xFF) << 0) + ((c2 & 0xFF) << 8);
        this.offset = this.dif.position();
        return res;
    }

    private String getIndent() {
        String retval = "";
        for (int i = 0; i < this.indentLevel; ++i) {
            retval = retval + "  ";
        }
        return retval;
    }

    public void reposition(FileChunkReference loc) throws IOException {
        this.reposition(loc.stp);
        this.end = this.offset + loc.cb;
    }

    private void reposition(long offset) throws IOException {
        this.offset = offset;
        this.dif.position(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneNotePtr internalDeserializeFileNodeList(OneNotePtr ptr, FileNodeList fileNodeList, FileNodePtr curPath) throws IOException, TikaException {
        OneNotePtr localPtr = new OneNotePtr(this.document, this.dif);
        FileNodePtrBackPush bp = new FileNodePtrBackPush(curPath);
        try {
            while (true) {
                FileChunkReference next = FileChunkReference.nil();
                ptr.deserializeFileNodeListFragment(fileNodeList, next, curPath);
                if (FileChunkReference.nil().equals(next)) break;
                localPtr.reposition(next);
                ptr = localPtr;
            }
            OneNotePtr oneNotePtr = ptr;
            return oneNotePtr;
        }
        finally {
            bp.dec();
        }
    }

    public OneNotePtr deserializeFileNodeList(FileNodeList fileNodeList, FileNodePtr curPath) throws IOException, TikaException {
        return this.internalDeserializeFileNodeList(this, fileNodeList, curPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deserializeFileNodeListFragment(FileNodeList data, FileChunkReference next, FileNodePtr curPath) throws IOException, TikaException {
        long footer;
        data.fileNodeListHeader = this.deserializeFileNodeListHeader();
        boolean terminated = false;
        while (this.offset + 24L <= this.end) {
            CheckedFileNodePushBack pushBack = new CheckedFileNodePushBack(data);
            try {
                long initialOffset = this.offset;
                FileNode fileNode = this.deserializeFileNode(data.children.get(data.children.size() - 1), curPath);
                if (initialOffset == this.offset) break;
                if (fileNode.id == 255L || fileNode.id == 0L) {
                    terminated = true;
                    break;
                }
                pushBack.commit();
                FileNode dereference = curPath.dereference(this.document);
                FileNode lastChild = data.children.get(data.children.size() - 1);
                assert (dereference.equals(lastChild));
                Integer curPathOffset = curPath.nodeListPositions.get(curPath.nodeListPositions.size() - 1);
                curPath.nodeListPositions.set(curPath.nodeListPositions.size() - 1, curPathOffset + 1);
            }
            finally {
                pushBack.popBackIfNotCommitted();
            }
        }
        this.reposition(this.end - 20L);
        FileChunkReference nextChunkRef = this.deserializeFileChunkReference64x32();
        next.cb = nextChunkRef.cb;
        next.stp = nextChunkRef.stp;
        if (terminated) {
            LOG.debug("{}Chunk terminator found NextChunkRef.cb={}, NextChunkRef.stp={}, Offset={}, End={}", new Object[]{this.getIndent(), nextChunkRef.cb, nextChunkRef.stp, this.offset, this.end});
        }
        if ((footer = this.deserializeLittleEndianLong()) != -8376108427508467125L) {
            throw new TikaException("Invalid footer constant. Expected -8376108427508467125 but was " + footer);
        }
    }

    private FileNode deserializeFileNode(FileNode data, FileNodePtr curPath) throws IOException, TikaException {
        OneNotePtr content;
        OneNotePtr backup = new OneNotePtr(this);
        data.isFileData = false;
        data.gosid = ExtendedGUID.nil();
        long fileNodeHeader = this.deserializeLittleEndianInt();
        data.id = fileNodeHeader & 0x3FFL;
        if (data.id == 0L) {
            return data;
        }
        LOG.debug("{}Start Node {} ({}) - Offset={}, End={}", new Object[]{this.getIndent(), FndStructureConstants.nameOf(data.id), data.id, this.offset, this.end});
        ++this.indentLevel;
        data.size = fileNodeHeader >> 10 & 0x1FFFL;
        this.end = backup.offset + data.size;
        long stpFormat = fileNodeHeader >> 23 & 3L;
        long cbFormat = fileNodeHeader >> 25 & 3L;
        data.baseType = fileNodeHeader >> 27 & 0xFL;
        long reserved = fileNodeHeader >> 31;
        data.ref = FileChunkReference.nil();
        if (data.baseType == 1L || data.baseType == 2L) {
            data.ref = this.deserializeVarFileChunkReference(stpFormat, cbFormat);
        }
        if (data.baseType == 1L && !data.ref.equals(FileChunkReference.nil())) {
            content = new OneNotePtr(this);
            content.reposition(data.ref);
        }
        if (data.id == 180L) {
            data.idDesc = "oid(group)";
            data.gosid = this.deserializeExtendedGUID();
        } else if (data.id != 184L) {
            if (data.id == 4L || data.id == 12L) {
                data.idDesc = data.id == 4L ? "gosidRoot" : "gosid";
                data.gosid = this.deserializeExtendedGUID();
            } else if (data.id == 8L) {
                data.gosid = this.deserializeExtendedGUID();
                data.idDesc = "gosid";
            } else if (data.id == 20L) {
                data.gosid = this.deserializeExtendedGUID();
                data.idDesc = "gosid";
                FileNodePtr parentPath = new FileNodePtr(curPath);
                parentPath.nodeListPositions.remove(parentPath.nodeListPositions.size() - 1);
                this.document.registerRevisionManifestList(data.gosid, parentPath);
                data.subType.revisionManifestListStart.nInstanceIgnored = this.deserializeLittleEndianInt();
            } else if (data.id == 27L) {
                data.gosid = this.deserializeExtendedGUID();
                data.idDesc = "rid";
                data.subType.revisionManifest.ridDependent = this.deserializeExtendedGUID();
                LOG.debug("{}dependent gosid {}", (Object)this.getIndent(), (Object)data.subType.revisionManifest.ridDependent);
                data.subType.revisionManifest.timeCreation = this.deserializeLittleEndianLong();
                data.subType.revisionManifest.revisionRole = this.deserializeLittleEndianInt();
                data.subType.revisionManifest.odcsDefault = this.deserializeLittleEndianShort();
                data.gctxid = ExtendedGUID.nil();
                this.document.registerRevisionManifest(data);
            } else if (data.id == 30L || data.id == 31L) {
                data.gosid = this.deserializeExtendedGUID();
                data.idDesc = "rid";
                data.subType.revisionManifest.ridDependent = this.deserializeExtendedGUID();
                LOG.debug("{}dependent gosid {}", (Object)this.getIndent(), (Object)data.subType.revisionManifest.ridDependent);
                data.subType.revisionManifest.revisionRole = this.deserializeLittleEndianInt();
                data.subType.revisionManifest.odcsDefault = this.deserializeLittleEndianShort();
                data.gctxid = ExtendedGUID.nil();
                if (data.id == 31L) {
                    data.gctxid = this.deserializeExtendedGUID();
                }
                this.document.registerAdditionalRevisionRole(data.gosid, data.subType.revisionManifest.revisionRole, data.gctxid);
                this.document.registerRevisionManifest(data);
            } else if (data.id == 33L) {
                data.subType.globalIdTableStartFNDX.reserved = this.deserializeLittleEndianChar();
            } else if (data.id == 36L) {
                data.subType.globalIdTableEntryFNDX.index = this.deserializeLittleEndianInt();
                data.subType.globalIdTableEntryFNDX.guid = this.deserializeGUID();
                this.document.revisionMap.get((Object)this.document.currentRevision).globalId.put(data.subType.globalIdTableEntryFNDX.index, data.subType.globalIdTableEntryFNDX.guid);
            } else if (data.id == 37L) {
                data.subType.globalIdTableEntry2FNDX.indexMapFrom = this.deserializeLittleEndianInt();
                data.subType.globalIdTableEntry2FNDX.indexMapTo = this.deserializeLittleEndianInt();
                ExtendedGUID dependentRevision = this.document.revisionMap.get((Object)this.document.currentRevision).dependent;
                GUID compactId = this.document.revisionMap.get((Object)dependentRevision).globalId.get(data.subType.globalIdTableEntry2FNDX.indexMapFrom);
                if (compactId == null) {
                    throw new TikaException("COMPACT_ID_MISSING");
                }
                this.document.revisionMap.get((Object)this.document.currentRevision).globalId.put(data.subType.globalIdTableEntry2FNDX.indexMapTo, compactId);
            } else if (data.id == 38L) {
                data.subType.globalIdTableEntry3FNDX.indexCopyFromStart = this.deserializeLittleEndianInt();
                data.subType.globalIdTableEntry3FNDX.entriesToCopy = this.deserializeLittleEndianInt();
                data.subType.globalIdTableEntry3FNDX.indexCopyToStart = this.deserializeLittleEndianInt();
                ExtendedGUID dependent_revision = this.document.revisionMap.get((Object)this.document.currentRevision).dependent;
                int i = 0;
                while ((long)i < data.subType.globalIdTableEntry3FNDX.entriesToCopy) {
                    Map<Long, GUID> globalIdMap = this.document.revisionMap.get((Object)dependent_revision).globalId;
                    GUID compactId = globalIdMap.get(data.subType.globalIdTableEntry3FNDX.indexCopyFromStart + (long)i);
                    if (compactId == null) {
                        throw new TikaException("COMPACT_ID_MISSING");
                    }
                    this.document.revisionMap.get((Object)this.document.currentRevision).globalId.put(data.subType.globalIdTableEntry3FNDX.indexCopyToStart + (long)i, compactId);
                    ++i;
                }
            } else if (data.id == 65L || data.id == 66L) {
                data.subType.objectRevisionWithRefCountFNDX.oid = this.deserializeCompactID();
                if (data.id == 65L) {
                    char ref = this.deserializeLittleEndianChar();
                    data.subType.objectRevisionWithRefCountFNDX.hasOidReferences = ref & '\u0001';
                    data.subType.objectRevisionWithRefCountFNDX.hasOsidReferences = ref & 2;
                    data.subType.objectRevisionWithRefCountFNDX.cRef = ref >> 2;
                } else {
                    long ref = this.deserializeLittleEndianInt();
                    data.subType.objectRevisionWithRefCountFNDX.hasOidReferences = ref & 1L;
                    data.subType.objectRevisionWithRefCountFNDX.hasOsidReferences = ref & 2L;
                    if (ref >> 2 != 0L) {
                        throw new TikaException("Reserved non-zero");
                    }
                    data.subType.objectRevisionWithRefCountFNDX.cRef = this.deserializeLittleEndianInt();
                }
            } else if (data.id == 89L) {
                data.subType.rootObjectReference.oidRoot = this.deserializeCompactID();
                data.idDesc = "oidRoot";
                data.gosid = data.subType.rootObjectReference.oidRoot.guid;
                data.subType.rootObjectReference.rootObjectReferenceBase.rootRole = this.deserializeLittleEndianInt();
                LOG.debug("{}Root role {}", (Object)this.getIndent(), (Object)data.subType.rootObjectReference.rootObjectReferenceBase.rootRole);
            } else if (data.id == 90L) {
                data.idDesc = "oidRoot";
                data.gosid = this.deserializeExtendedGUID();
                data.subType.rootObjectReference.rootObjectReferenceBase.rootRole = this.deserializeLittleEndianInt();
                LOG.debug("{}Root role {}", (Object)this.getIndent(), (Object)data.subType.rootObjectReference.rootObjectReferenceBase.rootRole);
            } else if (data.id == 92L || data.id == 93L) {
                data.gosid = this.deserializeExtendedGUID();
                data.subType.revisionRoleDeclaration.revisionRole = this.deserializeLittleEndianInt();
                if (data.id == 93L) {
                    data.gctxid = this.deserializeExtendedGUID();
                }
                this.document.registerAdditionalRevisionRole(data.gosid, data.subType.revisionRoleDeclaration.revisionRole, data.gctxid);
            } else if (data.id == 132L) {
                content = new OneNotePtr(this);
                if (!data.ref.equals(FileChunkReference.nil())) {
                    content.reposition(data.ref);
                }
                data.subType.objectInfoDependencyOverrides.data = content.deserializeObjectInfoDependencyOverrideData();
            } else if (data.id != 144L) {
                if (data.id == 148L) {
                    FileChunkReference ref = this.deserializeFileChunkReference64();
                    GUID guid = this.deserializeGUID();
                    ExtendedGUID extendedGuid = new ExtendedGUID(guid, 0L);
                    LOG.trace("found extended guid {}", (Object)extendedGuid);
                    this.document.guidToRef.put(extendedGuid, ref);
                    OneNotePtr fileDataStorePtr = new OneNotePtr(this);
                    fileDataStorePtr.reposition(data.ref);
                    data.subType.fileDataStoreObjectReference.ref = fileDataStorePtr.deserializeFileDataStoreObject();
                } else if (data.id == 45L || data.id == 46L || data.id == 164L || data.id == 165L || data.id == 196L || data.id == 197L) {
                    long refCnt;
                    data.subType.objectDeclarationWithRefCount.body.file_data_store_reference = false;
                    data.subType.objectDeclarationWithRefCount.body = data.id == 45L || data.id == 46L ? this.deserializeObjectDeclarationWithRefCountBody() : this.deserializeObjectDeclaration2Body();
                    data.subType.objectDeclarationWithRefCount.cRef = data.id == 45L || data.id == 164L || data.id == 196L ? (refCnt = (long)this.deserializeLittleEndianChar()) : this.deserializeLittleEndianInt();
                    if (data.id == 196L || data.id == 197L) {
                        ByteBuffer md5Buffer = ByteBuffer.allocate(16);
                        this.deserializeBytes(md5Buffer);
                        data.subType.objectDeclarationWithRefCount.readOnly.md5 = md5Buffer.array();
                    }
                    data.idDesc = "oid";
                    this.postprocessObjectDeclarationContents(data, curPath);
                    LOG.debug("{}Ref Count JCID {}", (Object)this.getIndent(), (Object)data.subType.objectDeclarationWithRefCount.body.jcid);
                } else if (data.id == 114L || data.id == 115L) {
                    data.subType.objectDeclarationWithRefCount.body.oid = this.deserializeCompactID();
                    long jcid = this.deserializeLittleEndianInt();
                    data.subType.objectDeclarationWithRefCount.body.jcid.loadFrom32BitIndex(jcid);
                    data.subType.objectDeclarationWithRefCount.cRef = data.id == 114L ? (long)this.deserializeLittleEndianChar() : this.deserializeLittleEndianInt();
                    long cch = this.deserializeLittleEndianInt();
                    long roomLeftLong = this.roomLeft();
                    if (cch > roomLeftLong) {
                        throw new TikaException("Data out of bounds - cch " + cch + " is > room left = " + roomLeftLong);
                    }
                    if (cch > this.dif.size()) {
                        throw new TikaMemoryLimitException("CCH=" + cch + " was found that was greater than file size " + this.dif.size());
                    }
                    ByteBuffer dataSpaceBuffer = ByteBuffer.allocate((int)cch * 2);
                    this.dif.read(dataSpaceBuffer);
                    byte[] dataSpaceBufferBytes = dataSpaceBuffer.array();
                    this.offset += (long)dataSpaceBufferBytes.length;
                    if (dataSpaceBufferBytes.length == 76 + IFNDF.length && Arrays.equals(IFNDF, Arrays.copyOfRange(dataSpaceBufferBytes, 0, IFNDF.length))) {
                        data.subType.objectDeclarationWithRefCount.body.file_data_store_reference = true;
                        GUID guid = GUID.fromCurlyBraceUTF16Bytes(Arrays.copyOfRange(dataSpaceBufferBytes, IFNDF.length, dataSpaceBufferBytes.length));
                        ExtendedGUID extendedGUID = new ExtendedGUID(guid, 0L);
                        FileChunkReference fileChunk = this.document.getAssocGuidToRef(extendedGUID);
                        if (fileChunk == null) {
                            LOG.debug("{} have not seen GUID {} yet", (Object)this.getIndent(), (Object)extendedGUID);
                        }
                    } else {
                        LOG.debug("{}Ignoring an external reference {}", (Object)this.getIndent(), (Object)new String(dataSpaceBufferBytes, StandardCharsets.UTF_16LE));
                    }
                } else if (data.id == 176L) {
                    data.idDesc = "object_group_id";
                    data.gosid = this.deserializeExtendedGUID();
                } else if (data.id == 180L) {
                    data.idDesc = "object_group_id";
                    data.gosid = this.deserializeExtendedGUID();
                } else if (data.id != 184L) {
                    if (data.id == 140L) {
                        data.idDesc = "data_sig";
                        data.gosid = this.deserializeExtendedGUID();
                    } else if (data.id == 16L) {
                        this.document.revisionMap.putIfAbsent(this.document.currentRevision, new Revision());
                        Revision currentRevision = this.document.revisionMap.get(this.document.currentRevision);
                        currentRevision.manifestList.add(curPath);
                    } else {
                        LOG.debug("No fnd needed to be parsed for data.id=0x" + Long.toHexString(data.id) + " (" + FndStructureConstants.nameOf(data.id) + ")");
                    }
                }
            }
        }
        if (data.baseType == 2L) {
            OneNotePtr subList = new OneNotePtr(this);
            subList.reposition(data.ref);
            subList.deserializeFileNodeList(data.childFileNodeList, curPath);
        }
        this.offset = backup.offset + data.size;
        this.end = backup.end;
        if (reserved != 1L) {
            throw new TikaException("RESERVED_NONZERO");
        }
        if (data.baseType == 1L && !data.ref.equals(FileChunkReference.nil())) {
            this.document.setAssocGuidToRef(data.gosid, data.ref);
            OneNotePtr content2 = new OneNotePtr(this);
            content2.reposition(data.ref);
            if (data.hasGctxid()) {
                LOG.debug("{}gctxid {}", (Object)this.getIndent(), (Object)data.gctxid);
            }
        } else if (!data.gosid.equals(ExtendedGUID.nil())) {
            LOG.trace("Non base type == 1 guid {}", (Object)data.gosid);
        }
        --this.indentLevel;
        if (data.gosid.equals(ExtendedGUID.nil())) {
            LOG.debug("{}End Node {} ({}) - Offset={}, End={}", new Object[]{this.getIndent(), FndStructureConstants.nameOf(data.id), (int)data.id, this.offset, this.end});
        } else {
            LOG.debug("{}End Node {} ({}) {}:[{}] - Offset={}, End={}", new Object[]{this.getIndent(), FndStructureConstants.nameOf(data.id), (int)data.id, data.idDesc, data.gosid, this.offset, this.end});
        }
        return data;
    }

    private void deserializeBytes(ByteBuffer byteBuffer) throws IOException {
        if (this.dif.position() != this.offset) {
            this.dif.position(this.offset);
        }
        this.dif.read(byteBuffer);
        this.offset = this.dif.position();
    }

    private ObjectDeclarationWithRefCountBody deserializeObjectDeclarationWithRefCountBody() throws IOException, TikaException {
        ObjectDeclarationWithRefCountBody data = new ObjectDeclarationWithRefCountBody();
        data.oid = this.deserializeCompactID();
        long jci_odcs_etc = this.deserializeLittleEndianInt();
        long reserved = this.deserializeLittleEndianShort();
        data.jcid.index = jci_odcs_etc & 0x3FFL;
        long must_be_zero = jci_odcs_etc >> 10 & 0xFL;
        long must_be_zeroA = jci_odcs_etc >> 14 & 3L;
        data.fHasOidReferences = (jci_odcs_etc >> 16 & 1L) != 0L;
        boolean bl = data.hasOsidReferences = (jci_odcs_etc >> 17 & 1L) != 0L;
        if (jci_odcs_etc >> 18 > 0L) {
            throw new TikaException("RESERVED_NONZERO");
        }
        if (reserved != 0L || must_be_zeroA != 0L || must_be_zero != 0L) {
            throw new TikaException("RESERVED_NONZERO");
        }
        return data;
    }

    private ObjectDeclarationWithRefCountBody deserializeObjectDeclaration2Body() throws IOException, TikaException {
        ObjectDeclarationWithRefCountBody data = new ObjectDeclarationWithRefCountBody();
        data.oid = this.deserializeCompactID();
        long jcid = this.deserializeLittleEndianInt();
        data.jcid.loadFrom32BitIndex(jcid);
        long hasRefs = this.deserializeLittleEndianChar();
        data.fHasOidReferences = (hasRefs & 1L) != 0L;
        data.hasOsidReferences = (hasRefs & 2L) != 0L;
        return data;
    }

    private FileDataStoreObject deserializeFileDataStoreObject() throws IOException, TikaException {
        FileDataStoreObject data = new FileDataStoreObject();
        GUID header = this.deserializeGUID();
        long len = this.deserializeLittleEndianLong();
        long unused = this.deserializeLittleEndianInt();
        long reserved = this.deserializeLittleEndianLong();
        if (this.offset + len + 16L > this.end) {
            throw new TikaException("SEGV error");
        }
        if (unused > 0L || reserved > 0L) {
            throw new TikaException("SEGV error");
        }
        data.fileData.stp = this.offset;
        data.fileData.cb = len;
        this.offset += len;
        while ((this.offset & 7L) > 0L) {
            ++this.offset;
        }
        GUID footer = this.deserializeGUID();
        return data;
    }

    private ObjectInfoDependencyOverrideData deserializeObjectInfoDependencyOverrideData() throws IOException {
        ObjectInfoDependencyOverrideData objectInfoDependencyOverrideData = new ObjectInfoDependencyOverrideData();
        long num_8bit_overrides = this.deserializeLittleEndianInt();
        long num_32bit_overrides = this.deserializeLittleEndianInt();
        long crc = this.deserializeLittleEndianInt();
        int i = 0;
        while ((long)i < num_8bit_overrides) {
            char local = this.deserializeLittleEndianChar();
            objectInfoDependencyOverrideData.overrides1.add(Integer.valueOf(local));
            ++i;
        }
        i = 0;
        while ((long)i < num_32bit_overrides) {
            long local = this.deserializeLittleEndianInt();
            objectInfoDependencyOverrideData.overrides2.add(local);
            ++i;
        }
        return objectInfoDependencyOverrideData;
    }

    private CompactID deserializeCompactID() throws IOException, TikaException {
        CompactID compactID = new CompactID();
        compactID.n = this.deserializeLittleEndianChar();
        compactID.guidIndex = this.deserializeInt24();
        compactID.guid = ExtendedGUID.nil();
        compactID.guid.n = compactID.n;
        Map<Long, GUID> globalIdMap = this.document.revisionMap.get((Object)this.document.currentRevision).globalId;
        long index = compactID.guidIndex;
        GUID guid = globalIdMap.get(index);
        if (guid == null) {
            throw new TikaException("COMPACT ID MISSING");
        }
        compactID.guid.guid = guid;
        return compactID;
    }

    private long deserializeInt24() throws IOException {
        char b1 = this.deserializeLittleEndianChar();
        char b2 = this.deserializeLittleEndianChar();
        char b3 = this.deserializeLittleEndianChar();
        return new Int24(b1, b2, b3).value();
    }

    private ExtendedGUID deserializeExtendedGUID() throws IOException {
        GUID guid = this.deserializeGUID();
        long n = this.deserializeLittleEndianInt();
        return new ExtendedGUID(guid, n);
    }

    FileChunkReference deserializeVarFileChunkReference(long stpFormat, long cbFormat) throws IOException, TikaException {
        long local16;
        long local32;
        FileChunkReference data = new FileChunkReference(0L, 0L);
        switch (new Long(stpFormat).intValue()) {
            case 0: {
                data.stp = this.deserializeLittleEndianLong();
                break;
            }
            case 1: {
                data.stp = local32 = this.deserializeLittleEndianInt();
                break;
            }
            case 2: {
                data.stp = local16 = this.deserializeLittleEndianShort();
                data.stp <<= 3;
                break;
            }
            case 3: {
                data.stp = local32 = this.deserializeLittleEndianInt();
                data.stp <<= 3;
                break;
            }
            default: {
                throw new TikaException("Unknown STP file node format " + stpFormat);
            }
        }
        switch (new Long(cbFormat).intValue()) {
            case 0: {
                data.cb = local32 = this.deserializeLittleEndianInt();
                break;
            }
            case 1: {
                data.cb = this.deserializeLittleEndianLong();
                break;
            }
            case 2: {
                long local8;
                data.cb = local8 = (long)this.deserializeLittleEndianChar();
                data.cb <<= 3;
                break;
            }
            case 3: {
                data.cb = local16 = this.deserializeLittleEndianShort();
                data.cb <<= 3;
                break;
            }
            default: {
                throw new TikaException("Unknown CB file node format " + cbFormat);
            }
        }
        return data;
    }

    FileNodeListHeader deserializeFileNodeListHeader() throws IOException {
        long positionOfThisHeader = this.offset;
        long uintMagic = this.deserializeLittleEndianLong();
        long fileNodeListId = this.deserializeLittleEndianInt();
        long nFragmentSequence = this.deserializeLittleEndianInt();
        return new FileNodeListHeader(positionOfThisHeader, uintMagic, fileNodeListId, nFragmentSequence);
    }

    private void postprocessObjectDeclarationContents(FileNode data, FileNodePtr curPtr) throws IOException, TikaException {
        data.gosid = data.subType.objectDeclarationWithRefCount.body.oid.guid;
        this.document.guidToObject.put(data.gosid, new FileNodePtr(curPtr));
        if (data.subType.objectDeclarationWithRefCount.body.jcid.isObjectSpaceObjectPropSet()) {
            OneNotePtr objectSpacePropSetPtr = new OneNotePtr(this);
            objectSpacePropSetPtr.reposition(data.ref);
            data.subType.objectDeclarationWithRefCount.objectRef = objectSpacePropSetPtr.deserializeObjectSpaceObjectPropSet();
            ObjectStreamCounters streamCounters = new ObjectStreamCounters();
            data.propertySet = objectSpacePropSetPtr.deserializePropertySet(streamCounters, data.subType.objectDeclarationWithRefCount.objectRef);
        } else {
            if (!data.subType.objectDeclarationWithRefCount.body.jcid.isFileData) {
                throw new TikaException("JCID must be file data when !isObjectSpaceObjectPropSet.");
            }
            data.isFileData = true;
            if (LOG.isDebugEnabled()) {
                OneNotePtr content = new OneNotePtr(this);
                content.reposition(data.ref);
                LOG.debug("{}Raw:", (Object)this.getIndent());
                content.dumpHex();
                LOG.debug("");
            }
        }
    }

    private PropertySet deserializePropertySet(ObjectStreamCounters counters, ObjectSpaceObjectPropSet streams) throws IOException, TikaException {
        PropertySet data = new PropertySet();
        long count = this.deserializeLittleEndianShort();
        data.rgPridsData = Stream.generate(PropertyValue::new).limit((int)count).collect(Collectors.toList());
        int i = 0;
        while ((long)i < count) {
            data.rgPridsData.get((int)i).propertyId = this.deserializePropertyID();
            LOG.debug("{}Property {}", (Object)this.getIndent(), (Object)data.rgPridsData.get((int)i).propertyId);
            ++i;
        }
        LOG.debug("{}{} elements in property set:", (Object)this.getIndent(), (Object)count);
        i = 0;
        while ((long)i < count) {
            data.rgPridsData.set(i, this.deserializePropertyValueFromPropertyID(data.rgPridsData.get((int)i).propertyId, streams, counters));
            ++i;
        }
        LOG.debug("");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyValue deserializePropertyValueFromPropertyID(OneNotePropertyId propertyID, ObjectSpaceObjectPropSet streams, ObjectStreamCounters counters) throws IOException, TikaException {
        PropertyValue data = new PropertyValue();
        data.propertyId = propertyID;
        long val32 = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\n{}<{}", (Object)this.getIndent(), (Object)propertyID);
        }
        ++this.indentLevel;
        try {
            long type = propertyID.type;
            switch ((int)type) {
                case 1: {
                    LOG.debug(" [] ");
                    PropertyValue propertyValue = data;
                    return propertyValue;
                }
                case 2: {
                    LOG.debug(" PropertyID bool({})", (Object)propertyID.inlineBool);
                    data.scalar = propertyID.inlineBool ? 1L : 0L;
                    PropertyValue propertyValue = data;
                    return propertyValue;
                }
                case 3: {
                    char val8 = this.deserializeLittleEndianChar();
                    data.scalar = val8;
                    LOG.debug(" PropertyID byte({})", (Object)data.scalar);
                    break;
                }
                case 4: {
                    long val16;
                    data.scalar = val16 = this.deserializeLittleEndianShort();
                    LOG.debug(" uint16 PropertyID short({})", (Object)data.scalar);
                    break;
                }
                case 5: {
                    data.scalar = val32 = this.deserializeLittleEndianInt();
                    LOG.debug(" PropertyID int({})", (Object)data.scalar);
                    break;
                }
                case 6: {
                    long val64;
                    data.scalar = val64 = this.deserializeLittleEndianLong();
                    LOG.debug(" PropertyID long({})", (Object)data.scalar);
                    break;
                }
                case 7: {
                    val32 = this.deserializeLittleEndianInt();
                    LOG.debug(" raw data: ({})[", (Object)val32);
                    data.rawData.stp = this.offset;
                    data.rawData.cb = 0L;
                    if (this.offset + val32 > this.end) {
                        data.rawData.cb = this.end - this.offset;
                        this.offset = this.end;
                        throw new TikaException("Offset is past end of file.");
                    }
                    data.rawData.cb = val32;
                    this.offset += val32;
                    if (LOG.isDebugEnabled()) {
                        OneNotePtr content = new OneNotePtr(this);
                        content.reposition(data.rawData);
                        content.dumpHex();
                    }
                    LOG.debug("]");
                    break;
                }
                case 9: 
                case 11: 
                case 13: {
                    val32 = this.deserializeLittleEndianInt();
                }
                case 8: 
                case 10: 
                case 12: {
                    if (type == 8L || type == 10L || type == 12L) {
                        val32 = 1L;
                    }
                    List<CompactID> stream = streams.contextIDs.data;
                    String xtype = "contextID";
                    long s_count = counters.context_ids_count;
                    if (type == 8L || type == 9L) {
                        stream = streams.oids.data;
                        s_count = counters.oids_count;
                        xtype = "OIDs";
                    }
                    if (type == 10L || type == 11L) {
                        stream = streams.osids.data;
                        s_count = counters.osids_count;
                        xtype = "OSIDS";
                    }
                    int i = 0;
                    while ((long)i < val32) {
                        int index = (int)s_count;
                        if (index >= stream.size()) {
                            throw new TikaException("SEGV");
                        }
                        data.compactIDs.add(stream.get(index));
                        LOG.debug(" {}[{}]", (Object)xtype, (Object)data.compactIDs.get(data.compactIDs.size() - 1));
                        ++i;
                        ++s_count;
                    }
                    break;
                }
                case 16: {
                    val32 = this.deserializeLittleEndianInt();
                    OneNotePropertyId propId = this.deserializePropertyID();
                    LOG.debug(" UnifiedSubPropertySet {} {}", (Object)val32, (Object)propId);
                    data.propertySet.rgPridsData = Stream.generate(PropertyValue::new).limit((int)val32).collect(Collectors.toList());
                    int i = 0;
                    while ((long)i < val32) {
                        try {
                            data.propertySet.rgPridsData.set(i, this.deserializePropertyValueFromPropertyID(propId, streams, counters));
                        }
                        catch (IOException e) {
                            PropertyValue propertyValue = data;
                            --this.indentLevel;
                            return propertyValue;
                        }
                        ++i;
                    }
                    break;
                }
                case 17: {
                    LOG.debug(" SubPropertySet");
                    data.propertySet = this.deserializePropertySet(counters, streams);
                    break;
                }
                default: {
                    throw new TikaException("Invalid type: " + type);
                }
            }
            LOG.debug(">");
            PropertyValue propertyValue = data;
            return propertyValue;
        }
        finally {
            --this.indentLevel;
        }
    }

    private OneNotePropertyId deserializePropertyID() throws IOException {
        long pid = this.deserializeLittleEndianInt();
        return new OneNotePropertyId(pid);
    }

    private ObjectSpaceObjectPropSet deserializeObjectSpaceObjectPropSet() throws IOException, TikaException {
        ObjectSpaceObjectPropSet data = new ObjectSpaceObjectPropSet();
        data.osids.extendedStreamsPresent = 0L;
        data.osids.osidsStreamNotPresent = 1L;
        data.contextIDs.extendedStreamsPresent = 0L;
        data.contextIDs.osidsStreamNotPresent = 0L;
        data.oids = this.deserializeObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs();
        if (data.oids.osidsStreamNotPresent == 0L) {
            data.osids = this.deserializeObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs();
        }
        if (data.oids.extendedStreamsPresent != 0L) {
            data.contextIDs = this.deserializeObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs();
        }
        return data;
    }

    private ObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs deserializeObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs() throws IOException, TikaException {
        ObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs data = new ObjectSpaceObjectStreamOfOIDsOSIDsOrContextIDs();
        long header = this.deserializeLittleEndianInt();
        data.count = header & 0xFFFFFFL;
        data.osidsStreamNotPresent = header >> 31 & 1L;
        data.extendedStreamsPresent = header >> 30 & 1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}Deserialized Stream Header count: {} OsidsNotPresent {} Extended {}", new Object[]{this.getIndent(), data.count, data.osidsStreamNotPresent, data.extendedStreamsPresent});
        }
        int i = 0;
        while ((long)i < data.count) {
            CompactID cid = this.deserializeCompactID();
            data.data.add(cid);
            ++i;
        }
        return data;
    }

    long roomLeft() {
        return this.end - this.offset;
    }

    public void dumpHex() throws TikaMemoryLimitException, IOException {
        if (this.end - this.offset > this.dif.size()) {
            throw new TikaMemoryLimitException("Exceeded memory limit when trying to dumpHex - " + (this.end - this.offset) + " > " + this.dif.size());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(this.end - this.offset));
        LOG.debug(Hex.encodeHexString((byte[])byteBuffer.array()));
    }

    public int size() {
        return (int)(this.end - this.offset);
    }
}

