/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.RecordFormatException;

public class HwmfBitmapDib {
    private static final int MAX_RECORD_LENGTH = 10000000;
    private static final POILogger logger = POILogFactory.getLogger(HwmfBitmapDib.class);
    private static final int BMP_HEADER_SIZE = 14;
    private int headerSize;
    private int headerWidth;
    private int headerHeight;
    private int headerPlanes;
    private BitCount headerBitCount;
    private Compression headerCompression;
    private long headerImageSize = -1L;
    private int headerXPelsPerMeter = -1;
    private int headerYPelsPerMeter = -1;
    private long headerColorUsed = -1L;
    private long headerColorImportant = -1L;
    private Color[] colorTable;
    private int colorMaskR;
    private int colorMaskG;
    private int colorMaskB;
    private int introSize;
    private byte[] imageData;

    public int init(LittleEndianInputStream leis, int recordSize) throws IOException {
        leis.mark(10000);
        this.introSize = this.readHeader(leis);
        assert (this.introSize == this.headerSize);
        this.introSize += this.readColors(leis);
        assert (this.introSize < 10000);
        int fileSize = this.headerImageSize < (long)this.headerSize ? recordSize : (int)Math.min((long)this.introSize + this.headerImageSize, (long)recordSize);
        leis.reset();
        this.imageData = IOUtils.toByteArray((InputStream)leis, (int)fileSize);
        assert (this.headerSize != 12 || (long)((this.headerWidth * this.headerPlanes * this.headerBitCount.flag + 31 & 0xFFFFFFE0) / 8 * Math.abs(this.headerHeight)) == this.headerImageSize);
        return fileSize;
    }

    protected int readHeader(LittleEndianInputStream leis) throws IOException {
        int size = 0;
        this.headerSize = leis.readInt();
        size += 4;
        if (this.headerSize == 12) {
            this.headerWidth = leis.readUShort();
            this.headerHeight = leis.readUShort();
            this.headerPlanes = leis.readUShort();
            this.headerBitCount = BitCount.valueOf(leis.readUShort());
            size += 8;
        } else {
            this.headerWidth = leis.readInt();
            this.headerHeight = leis.readInt();
            this.headerPlanes = leis.readUShort();
            this.headerBitCount = BitCount.valueOf(leis.readUShort());
            this.headerCompression = Compression.valueOf((int)leis.readUInt());
            this.headerImageSize = leis.readUInt();
            this.headerXPelsPerMeter = leis.readInt();
            this.headerYPelsPerMeter = leis.readInt();
            this.headerColorUsed = leis.readUInt();
            this.headerColorImportant = leis.readUInt();
            size += 36;
        }
        assert (size == this.headerSize);
        return size;
    }

    protected int readColors(LittleEndianInputStream leis) throws IOException {
        switch (this.headerBitCount) {
            default: {
                return 0;
            }
            case BI_BITCOUNT_1: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 2L : Math.min(this.headerColorUsed, 2L)));
            }
            case BI_BITCOUNT_2: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 16L : Math.min(this.headerColorUsed, 16L)));
            }
            case BI_BITCOUNT_3: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 256L : Math.min(this.headerColorUsed, 256L)));
            }
            case BI_BITCOUNT_4: {
                switch (this.headerCompression) {
                    case BI_RGB: {
                        this.colorMaskB = 31;
                        this.colorMaskG = 992;
                        this.colorMaskR = 31744;
                        return 0;
                    }
                    case BI_BITFIELDS: {
                        this.colorMaskB = leis.readInt();
                        this.colorMaskG = leis.readInt();
                        this.colorMaskR = leis.readInt();
                        return 12;
                    }
                }
                throw new IOException("Invalid compression option (" + (Object)((Object)this.headerCompression) + ") for bitcount (" + (Object)((Object)this.headerBitCount) + ").");
            }
            case BI_BITCOUNT_5: 
            case BI_BITCOUNT_6: 
        }
        switch (this.headerCompression) {
            case BI_RGB: {
                this.colorMaskR = 255;
                this.colorMaskG = 255;
                this.colorMaskB = 255;
                return 0;
            }
            case BI_BITFIELDS: {
                this.colorMaskB = leis.readInt();
                this.colorMaskG = leis.readInt();
                this.colorMaskR = leis.readInt();
                return 12;
            }
        }
        throw new IOException("Invalid compression option (" + (Object)((Object)this.headerCompression) + ") for bitcount (" + (Object)((Object)this.headerBitCount) + ").");
    }

    protected int readRGBQuad(LittleEndianInputStream leis, int count) throws IOException {
        int size = 0;
        this.colorTable = new Color[count];
        for (int i = 0; i < count; ++i) {
            int blue = leis.readUByte();
            int green = leis.readUByte();
            int red = leis.readUByte();
            int reserved = leis.readUByte();
            this.colorTable[i] = new Color(red, green, blue);
            size += 4;
        }
        return size;
    }

    public InputStream getBMPStream() {
        return new ByteArrayInputStream(this.getBMPData());
    }

    private byte[] getBMPData() {
        if (this.imageData == null) {
            throw new RecordFormatException("bitmap not initialized ... need to call init() before");
        }
        int imageSize = (int)Math.max((long)this.imageData.length, (long)this.introSize + this.headerImageSize);
        byte[] buf = IOUtils.safelyAllocate((long)(14 + imageSize), (int)10000000);
        buf[0] = 66;
        buf[1] = 77;
        LittleEndian.putInt((byte[])buf, (int)2, (int)(14 + imageSize));
        LittleEndian.putInt((byte[])buf, (int)6, (int)0);
        LittleEndian.putInt((byte[])buf, (int)10, (int)(14 + this.introSize));
        System.arraycopy(this.imageData, 0, buf, 14, this.imageData.length);
        return buf;
    }

    public BufferedImage getImage() {
        try {
            return ImageIO.read(this.getBMPStream());
        }
        catch (IOException e) {
            logger.log(7, new Object[]{"invalid bitmap data - returning black opaque image"});
            BufferedImage bi = new BufferedImage(this.headerWidth, this.headerHeight, 2);
            Graphics2D g = bi.createGraphics();
            g.setPaint(Color.black);
            g.fillRect(0, 0, this.headerWidth, this.headerHeight);
            g.dispose();
            return bi;
        }
    }

    public static enum Compression {
        BI_RGB(0),
        BI_RLE8(1),
        BI_RLE4(2),
        BI_BITFIELDS(3),
        BI_JPEG(4),
        BI_PNG(5),
        BI_CMYK(11),
        BI_CMYKRLE8(12),
        BI_CMYKRLE4(13);

        int flag;

        private Compression(int flag) {
            this.flag = flag;
        }

        static Compression valueOf(int flag) {
            for (Compression c : Compression.values()) {
                if (c.flag != flag) continue;
                return c;
            }
            return null;
        }
    }

    public static enum BitCount {
        BI_BITCOUNT_0(0),
        BI_BITCOUNT_1(1),
        BI_BITCOUNT_2(4),
        BI_BITCOUNT_3(8),
        BI_BITCOUNT_4(16),
        BI_BITCOUNT_5(24),
        BI_BITCOUNT_6(32);

        int flag;

        private BitCount(int flag) {
            this.flag = flag;
        }

        static BitCount valueOf(int flag) {
            for (BitCount bc : BitCount.values()) {
                if (bc.flag != flag) continue;
                return bc;
            }
            return null;
        }
    }
}

